package org.openliberty.xmltooling.subs;

import org.joda.time.DateTime;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.opensaml.core.xml.AbstractXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 *  <pre>
 *   &lt;xs:attributeGroup name="NotifyAttributeGroup"&gt;
 *     &lt;xs:attribute name="timeStamp" use="optional" type="xs:dateTime"/&gt;
 *   &lt;/xs:attributeGroup&gt;
 *   </pre>
 */
public class NotifyAttributeGroup {

    // Attribute Names
    public static final String TIMESTAMP = "timeStamp";

    // Attributes
    private DateTime timeStamp;
    
    
    /**
     * This is a convenience method used by any Marshaller that is marshalling 
     * an object that has a CreateItemAttributeGroup
     *
     */
    public void marshallAttributes(Element domElement)
    {        
        if(timeStamp!=null)
        {
            domElement.setAttributeNS(null, TIMESTAMP, OpenLibertyHelpers.stringForDateTime(timeStamp));
        }
    }

    /**
     * This method assists the unmarshaller, adding an XML Attribute to 
     * the CreateItemAttributeGroup object
     *     
     * @param attribute the attribute to set
     * 
     * @return whether an attribute was found and set
     */
    public boolean processAttribute(Attr attribute, AbstractXMLObject abstractXMLObject)
    {

        if (attribute.getLocalName().equals(TIMESTAMP)) 
        {
            this.setTimeStamp(OpenLibertyHelpers.dateTimeForString(attribute.getValue()), abstractXMLObject);
            return true;
        }
        
        return false;

    }
    
    public void setTimeStamp(DateTime timeStamp, AbstractXMLObject abstractXMLobject)
    {
        this.timeStamp = OpenLibertyHelpers.prepareForAssignment(this.timeStamp, timeStamp, abstractXMLobject);
    }
    
    public DateTime getTimeStamp()
    {
        return timeStamp;
    }
    
    
}