package org.openliberty.xmltooling.subs;

import java.util.List;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * The &lt;RefItem&gt; element is used when a WSC wants to subscribe to the data it is accessing with the RequestElement.
 *
 * <p>
 * <pre>
  <xs:complexType name="RefItemType">
    <xs:attribute name="subscriptionID" use="optional" type="lu:IDType"/>
    <xs:attribute ref="lu:itemIDRef" use="required"/>
  </xs:complexType> 
 *</pre>
 *</p>
 *
 * @author asa
 *
 */
public class RefItem extends AbstractSignableXMLObject
{
    
    public static String LOCAL_NAME = "RefItem";
    
    // Attributes
    private String subscriptionID;  // lu:IDType, optional
    private String itemIDRef;       // lu:itemIDRef, required
    
    // Attribute names
    public static String ATT_SUBSCRIPTION_ID = "subscriptionID";
    public static String ATT_ITEM_REF_ID = "itemIDRef";
        
    
    public RefItem()
    {
        super(Konstantz.SUBS_NS, LOCAL_NAME, Konstantz.SUBS_PREFIX);
    }
    
    protected RefItem(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public List<XMLObject> getOrderedChildren()
    {
        return null;
    }
    
    public String getSubscriptionID()
    {
        return subscriptionID;        
    }
    
    public void setSubscriptionID(String subscriptionID)
    {
        this.subscriptionID = prepareForAssignment(this.subscriptionID, subscriptionID);      
    }

    public String getItemRefID()
    {
        return itemIDRef;        
    }
    
    public void setItemRefID(String itemIDRef)
    {
        this.itemIDRef = prepareForAssignment(this.itemIDRef, itemIDRef);      
    }

    
    /**
     * Internal builder class simplifies the file structure
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<RefItem> 
    {

        @Override
		public RefItem buildObject(String namespaceURI, String localName, String namespacePrefix) 
        {
            return new RefItem(namespaceURI, localName, namespacePrefix);
        }

    }
    
    /**
     * Static Marshaller
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            RefItem object = (RefItem)xmlObject;

            if(object.getItemRefID() != null) 
            {
                domElement.setAttributeNS(null, RefItem.ATT_ITEM_REF_ID, object.getItemRefID());
            }
            
            if(object.getSubscriptionID() != null)
            {
                domElement.setAttributeNS(null, RefItem.ATT_SUBSCRIPTION_ID, object.getSubscriptionID());
            }
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            // no element content
        }
        
    }
    
    
    /**
     * Static Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
        {
            RefItem object = (RefItem) xmlObject;

            if (attribute.getLocalName().equals(RefItem.ATT_ITEM_REF_ID)) 
            {
                object.setItemRefID(attribute.getValue());
            }
            else if (attribute.getLocalName().equals(RefItem.ATT_SUBSCRIPTION_ID)) 
            {
                object.setSubscriptionID(attribute.getValue());
            }           
        }

        
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
        {   
            // no child elements
        }

        
        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent) 
        {
            // NO CONTENT
        }

    }
    
}
