package org.openliberty.xmltooling.utility_2_0;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import javax.xml.namespace.QName;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.ElementExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * An element that contains arbitrary content extensions from other namespaces.
 * 
 * @author asa
 *
 */
public class Extension extends AbstractSignableXMLObject implements ElementExtensibleXMLObject
{
    public static final String LOCAL_NAME = "Extension";

    private IndexedXMLObjectChildrenList<XMLObject> unknownXMLObjects;

    public Extension()
    {
        super(Konstantz.LU_NS, LOCAL_NAME, Konstantz.LU_PREFIX);
        unknownXMLObjects = new IndexedXMLObjectChildrenList<XMLObject>(this);
    }

    protected Extension(String namespaceURI, String elementLocalName, String namespacePrefix) 
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        unknownXMLObjects = new IndexedXMLObjectChildrenList<XMLObject>(this);
    }

    public List<XMLObject> getOrderedChildren() 
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
        children.addAll(getUnknownXMLObjects());
        return Collections.unmodifiableList(children);
    }	

    public List<XMLObject> getUnknownXMLObjects() 
    {		
        return unknownXMLObjects;
    }

    @SuppressWarnings("unchecked")
    public List<XMLObject> getUnknownXMLObjects(QName typeOrName)
    {
        return (List<XMLObject>) unknownXMLObjects.subList(typeOrName);
    }


    /**
     * This method attempts to find an XMLObject in the unknownXMLObjects
     * and if there are none, creates one, adds it to the unknownObjects, and 
     * returns it.
     * 
     * @param typeOrName
     * @return
     */
    public XMLObject findFirstOrCreateXMLObjectWithQName(QName typeOrName)
    {
        List<XMLObject> list = getUnknownXMLObjects(typeOrName);

        if(list.size()>0) return list.get(0);
        else
        {
            XMLObjectBuilder<?> builder = XMLObjectSupport.getBuilder(typeOrName);
            if (builder == null) 
            {
                System.err.println("Unable to retrieve builder for object QName " + typeOrName);
            }
            else
            {
                XMLObject object = builder.buildObject(typeOrName.getNamespaceURI(), typeOrName.getLocalPart(), typeOrName.getPrefix());
                if(null!=object)
                {
                    getUnknownXMLObjects().add(object);   
                    return object;
                }

            }
        }

        return null;
    }




    public static class Marshaller extends AbstractXMLObjectMarshaller
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            // no atts
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            // no element content
        }

    }

    /**
     * Internal Unmarshaller class, Unmarshall DOM to objects
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            // no atts
        }

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            Extension obj = (Extension) parentXMLObject;
            obj.getUnknownXMLObjects().add(childXMLObject);
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent)
        {
            // no att content
        }

    }

    /**
     * Internal builder class
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<Extension>
    {
        @Override
        public Extension buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new Extension(namespaceURI, localName, namespacePrefix);
        }
    }


}
