package org.openliberty.xmltooling.utility_2_0;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * 
 * lu:ResponseType
 * <pre>
 *    &lt;xs:complexType name="ResponseType"&gt;
 *         &lt;xs:sequence&gt;
 *             &lt;xs:element ref="Status"       minOccurs="1" maxOccurs="1"/&gt;
 *             &lt;xs:element ref="Extension"    minOccurs="0" maxOccurs="unbounded"/&gt;
 *         &lt;/xs:sequence&gt;
 *         &lt;xs:attribute ref="itemIDRef" use="optional"/&gt;
 *         &lt;xs:anyAttribute namespace="##other" processContents="lax"/&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * 
 * @author asa
 *
 */
public abstract class ResponseType extends AbstractXMLObject implements AttributeExtensibleXMLObject
{
    
    public static final String ATT_ITEM_ID_REF = "itemIDRef";
    
    // Elements
    private Status status;  // required
    private XMLObjectChildrenList<Extension> extensions;
    
    // Attributes
    private String itemIDRef;                  // optional
    private AttributeMap otherAttributes;

    protected ResponseType(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        otherAttributes = new AttributeMap(this);
    }
  
    public boolean statusIsFailed()
    {
        if(null!=status) return status.isFailed();
        else return false;
    }

    public boolean statusIsOK()
    {
        if(null!=status) return status.isOK();
        return false;
    }

    
    public void setItemRefId(String itemIDRef)
    {
        this.itemIDRef = prepareForAssignment(this.itemIDRef, itemIDRef);
    }
    
    public String getItemRefId()
    {
        return itemIDRef;
    }
    
    /**
     * The code of the top level Status element, which this method returns, 
     * must have a value of  OK, Partial or Failed. 
     * 
     * @return
     */
    public Status getStatus()
    {
        return status;
    }
    
    public void setStatus(Status status)
    {
        this.status = status;
    }
    
    public XMLObjectChildrenList<Extension> getExtensions()
    {
        if(null==extensions) extensions = new XMLObjectChildrenList<Extension>(this);
        return extensions;
    }

    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        if(null!=extensions) children.addAll(extensions);
        
        return Collections.unmodifiableList(children);
    }

    
    public AttributeMap getUnknownAttributes()
    {
        return otherAttributes;
    }

    
    /**
     * Internal marshaller, placing attribute values into the DOM
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
           ResponseType obj = (ResponseType)xmlObject;
            
            if(obj.getItemRefId() != null) 
            {
                domElement.setAttributeNS(null, ResponseType.ATT_ITEM_ID_REF, obj.getItemRefId());
            } 
            
            // marshall the unknown attributes (supported by RequestType)
            Attr attr;
            for(Entry<QName, String> entry: obj.getUnknownAttributes().entrySet())
            {
                attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
                attr.setValue(entry.getValue());
                domElement.setAttributeNodeNS(attr);
                if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || obj.getUnknownAttributes().isIDAttribute(entry.getKey())) 
                {
                    attr.getOwnerElement().setIdAttributeNode(attr, true);
                }
            }            
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            // no element content
        }
        
    }
    
    /**
     * Internal unmarshaller, placing DOM atts into the ResponseType
     * and connecting child elements
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            ResponseType obj = (ResponseType) xmlObject;
            
            if (attribute.getLocalName().equals(ResponseType.ATT_ITEM_ID_REF)) 
            {
                obj.setItemRefId(attribute.getValue());
            } 
            // xs:anyAttribute
            else 
            {
                QName attribQName = QNameSupport.getNodeQName(attribute);
                if (attribute.isId()) 
                {
                    obj.getUnknownAttributes().registerID(attribQName);
                }
                obj.getUnknownAttributes().put(attribQName, attribute.getValue());
            }          
        }

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            ResponseType obj = (ResponseType) parentXMLObject;
            
            if(childXMLObject instanceof Status)
            {
                obj.setStatus((Status)childXMLObject);                   
            }
            else if(childXMLObject instanceof Extension)
            {
                obj.getExtensions().add((Extension)childXMLObject);                   
            }
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent)
        {
            // no element content
        }

        
    }
    
    
    
}
