package org.openliberty.xmltooling.utility_2_0;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import javax.xml.namespace.QName;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * The Liberty Utility v2.0 Status element lu:Status
 * 
 * @author asa
 *
 */
public class Status extends AbstractSignableXMLObject
{
    public static final String LOCAL_NAME = "Status";

    public static final QName LOCAL_Q_NAME = new QName(Konstantz.LU_NS, LOCAL_NAME, Konstantz.LU_PREFIX);
    
    public static final String CONTINUE = "Continue";    
    public static final String OK = "OK";
    public static final String FAILED = "Failed";
    
    public static String ATT_CODE = "code";
    public static String ATT_REF = "ref";    
    public static String ATT_COMMENT = "comment";

    // Atributes
    private String code;        // required
    private String ref;    // optional. This type can be used when referring to elements that are identified using an IDType.
    private String comment;     // optional
    
    // Elements
    private XMLObjectChildrenList<Status> stati;

    protected Status(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public String getCode()
    {
        return code;
    }
    
    
    public boolean isFailed()
    {
        if(null!=code && code.endsWith(FAILED)) return true;
        else return false;
    }
    
    /**
     * Needed to handle the case where the data is namespaced, so we are checking for 
     * Status that ends with OK
     * <br/>
     * &lt;pp:Status code="pp:OK"&gt;&lt;/pp:Status&gt;
     * 
     * @return
     */
    public boolean isOK()
    {        
        if(null!=code && code.endsWith(OK)) return true;
        else return false;
    }

    

    /**
     * This is a required attribute of the status element. 
     * 
     * @param code
     */
    public void setCode(String code)
    {
        this.code = prepareForAssignment(this.code, code);
    }

    /**
     * This is an IDReferenceType. This type can be used when referring to 
     * elements that are identified using an IDType.
     * 
     * @return an IDReferenceType
     */
    public String getRef()
    {
        return ref;
    }

    public void setRef(String ref)
    {
        this.ref = prepareForAssignment(this.ref, ref);
    }

    public String getComment()
    {
        return comment;
    }

    public void setComment(String comment)
    {
        this.comment = prepareForAssignment(this.comment, comment);
    }
    
    public XMLObjectChildrenList<Status> getStati()
    {
        if(null==stati) stati = new XMLObjectChildrenList<Status>(this);
        return stati;
    }

    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        if(null!=stati) children.addAll(stati);
        
        return Collections.unmodifiableList(children);
    }

    
    /**
     * @author tguion
     * (see liberty-idwsf-soap-binding-2.0-errata-v1.0.pdf)
     */
    public enum StatusCode {
        INVALIDACTOR("InvalidActor", "There is an issue with the actor attribute on the indicated header block in the indicated message.", "C"),
        INVALIDMUSTUNDERSTAND("InvalidMustUnderstand", "There is an issue with the mustUnderstand attribute on the indicated header block in the indicated message.", "C"); 
        // TODO: complete from referenced table in spec
        
        private final String code;
        private final String semantics;
        private final String source;
        
        StatusCode(String code, String semantics, String source) {
            this.code = code;
            this.semantics = semantics;
            this.source = source;
        }
        
        public boolean isClientSource() { return "C".equals(source); }
        public boolean isServerSource() { return "S".equals(source); }

        /**
         * @return the code
         */
        public String getCode() {
            return code;
        }

        /**
         * @return the semantics
         */
        public String getSemantics() {
            return semantics;
        }

        /**
         * @return the source
         */
        public String getSource() {
            return source;
        }
    }
    
    
    /**
     * This is the internal Unmarshalling class for lu:Status
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {
        
        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
        {
            Status status = (Status) xmlObject;

            if (attribute.getLocalName().equals(Status.ATT_CODE)) 
            {
                status.setCode(attribute.getValue());
            } else if (attribute.getLocalName().equals(Status.ATT_REF)) 
            {
                status.setRef(attribute.getValue());
            } else if (attribute.getLocalName().equals(Status.ATT_COMMENT)) 
            {
                status.setComment(attribute.getValue());
            }           
        }

        
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
        {   
            
            if(childXMLObject instanceof Status)
            {
                ((Status)parentXMLObject).getStati().add((Status) childXMLObject);            
            }
            
        }

        
        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent) 
        {
            // NO CONTENT
        }
    }
    
    
    /**
     * Internal marshaller for the lu:Status element
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {
        
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            Status status = (Status)xmlObject;
            
            if(status.getCode() != null)
            {
                domElement.setAttributeNS(null, Status.ATT_CODE, status.getCode());
            }        
            
            if(status.getComment() != null)
            {
                domElement.setAttributeNS(null, Status.ATT_COMMENT, status.getComment());
            }
            
            if(status.getRef() != null)
            {
                domElement.setAttributeNS(null, Status.ATT_REF, status.getRef());
            }
            
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            // NO TEXT CONTENT      
        }


    }
    
    
    /**
     * Internal Builder class for the lu:Status element
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<Status> 
    {

        public Status buildObject()
        {
            return buildObject(Konstantz.LU_NS, Status.LOCAL_NAME, Konstantz.LU_PREFIX);
        }

        @Override
		public Status buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new Status(namespaceURI, localName, namespacePrefix);
        }
        
    }
    

}


/*
<xs:complexType name="StatusType">
<xs:annotation>
    <xs:documentation> 
        A type that may be used for status codes. 
    </xs:documentation>
</xs:annotation>
<xs:sequence>
    <xs:element ref="Status" minOccurs="0" maxOccurs="unbounded"/>
</xs:sequence>
<xs:attribute name="code" type="xs:string" use="required"/>
<xs:attribute name="ref" type="IDReferenceType" use="optional"/>
<xs:attribute name="comment" type="xs:string" use="optional"/>
</xs:complexType>

<xs:element name="Status" type="StatusType">
<xs:annotation>
    <xs:documentation> 
        A standard Status type
    </xs:documentation>
</xs:annotation>
</xs:element>

*/