package org.openliberty.xmltooling.utility_2_0;

import java.util.List;

import net.shibboleth.utilities.java.support.xml.ElementSupport;

import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;


/**
 * 
 * <pre>
 *     &lt;xs:element name="TestResult" type="TestResultType"/&gt;
 *     &lt;xs:complexType name="TestResultType"&gt;
 *         &lt;xs:simpleContent&gt;
 *             &lt;xs:extension base="xs:boolean"&gt;
 *                 &lt;xs:attribute ref="itemIDRef" use="required"/&gt;
 *             &lt;/xs:extension&gt;
 *         &lt;/xs:simpleContent&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class TestResult extends AbstractSignableXMLObject
{
    
    public static String LOCAL_NAME = "TestResult";
    
    // Element Value
    private Boolean value;
    
    // Attributes
    private String itemIDRef; // required 
 
    // Attribute Name
    public static String ATT_ITEM_REF_ID = "itemIDRef";
    
    protected TestResult(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    
    public String getItemIDRef()
    {
        return  itemIDRef;
    }
    
    public void setItemIDRef(String itemIDRef)
    {
        this.itemIDRef = prepareForAssignment(this.itemIDRef, itemIDRef);
    }
    
    public Boolean getValue()
    {
        return value;
    }
    
    public void setValue(Boolean value)
    {
        this.value = prepareForAssignment(this.value, value);
    }    
    
    public List<XMLObject> getOrderedChildren()
    {
        // no chilluns
        return null;
    }
    
    /**
     * Internal Marshaller 
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            TestResult obj = (TestResult)xmlObject;
            if(obj.getItemIDRef() != null) 
            {
                domElement.setAttributeNS(null, TestResult.ATT_ITEM_REF_ID, obj.getItemIDRef());
            } 
            
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            TestResult obj = (TestResult) xmlObject;
            ElementSupport.appendTextContent(domElement, OpenLibertyHelpers.stringFromBoolean(obj.getValue(), OpenLibertyHelpers.FALSE_STR));
        }
        
    }
    
    /**
     * Internal unmarshaller class
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException
        {
            TestResult obj = (TestResult)xmlObject;
            if(attribute.getLocalName().equals(TestResult.ATT_ITEM_REF_ID))
            {
                obj.setItemIDRef(attribute.getNodeValue());
            }
        }

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException
        {
            // no children            
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent)
        {
            TestResult obj = (TestResult) xmlObject;
            obj.setValue(OpenLibertyHelpers.booleanFromString( elementContent ));            
        }
        
    }
    
    
    
    public static class Builder extends AbstractXMLObjectBuilder<TestResult>
    {
        @Override
        public TestResult buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new TestResult(namespaceURI, localName, namespacePrefix);
        }        
    }
    
    
    
    
}
