package org.openliberty.xmltooling.wsa;

import java.util.List;
import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * The &lt;wsa:Action&gt; header block is defined in [WSAv1.0-SOAP]. The value of this header block uniquely identifies
 * the semantics implied by the message.
 * 
 * @author tguion
 * 
 */
public class Action extends AbstractSignableXMLObject implements AttributeExtensibleXMLObject 
{
	
	public static String DEFAULT_ELEMENT_LOCAL_NAME = "Action";
	
	public static QName DEFAULT_ELEMENT_NAME = QNameSupport.constructQName(Konstantz.WSA_NS, DEFAULT_ELEMENT_LOCAL_NAME, Konstantz.WSA_PREFIX);
	//public static QName DEFAULT_ELEMENT_NAME = XMLHelper.constructQName(Konstantz.DISCO_NS, DEFAULT_ELEMENT_LOCAL_NAME, Konstantz.DISCO_PREFIX);

	/**
	 * Content: anyURI
	 */
	private String value;
	
	/**
	 * Support for AttributeExtensibleXMLObject interface
	 */
	private AttributeMap otherAttributes;	
	
    
    public Action()
    {
        super(Konstantz.WSA_NS, Action.DEFAULT_ELEMENT_LOCAL_NAME, Konstantz.WSA_PREFIX);
    }
    
    /**
     * Constructor
     * 
     * @param namespaceURI the namespace the element is in
     * @param elementLocalName the local name of the XML element this Object represents
     * @param namespacePrefix the prefix for the given namespace
     */
	protected Action(String namespaceURI, String elementLocalName, String namespacePrefix) 
	{
		super(namespaceURI, elementLocalName, namespacePrefix);				
	}

	public List<XMLObject> getOrderedChildren() 
	{
		return null;
	}	
	
    public void setValue(String value) 
    {
    	this.value = prepareForAssignment(this.value, value);
    }
    
    public String getValue() 
    { 
    	return value; 
    }
    
	/* (non-Javadoc)
	 * @see org.opensaml.xml.AttributeExtensibleXMLObject#getUnknownAttributes()
	 */
	public AttributeMap getUnknownAttributes() 
	{
	    if(null==otherAttributes) otherAttributes = new AttributeMap(this);
	    return otherAttributes;
	}

    
    
    
    /**
     * Internal Unmarshaller
     * @author asa
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
        {
            Action action = (Action) xmlObject;
            QName attribQName = QNameSupport.getNodeQName(attribute);
            if (attribute.isId()) {
                action.getUnknownAttributes().registerID(attribQName);
            }
            action.getUnknownAttributes().put(attribQName, attribute.getValue());
        }

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
        {
            // no children
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent) 
        {
            Action action = (Action) xmlObject;
            action.setValue(elementContent);
        }


    }

    
    
    /**
     * Internal Marshaller
     * 
     * @author asa
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            Action action = (Action) xmlObject; 
            
            Attr attr;
            for(Entry<QName, String> entry: action.getUnknownAttributes().entrySet()){
                attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
                attr.setValue(entry.getValue());
                domElement.setAttributeNodeNS(attr);
                if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || action.getUnknownAttributes().isIDAttribute(entry.getKey())) {
                    attr.getOwnerElement().setIdAttributeNode(attr, true);
                }
            }       
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            Action action = (Action) xmlObject;
            ElementSupport.appendTextContent(domElement, action.getValue());     
        }


    }


    
    
    
	/**
     * Internal Action Builder
     * 
     * @author asa
	 */
    public static class Builder extends AbstractXMLObjectBuilder<Action> 
    {
        @Override
        public Action buildObject(String namespaceURI, String localName, String namespacePrefix) 
        {
            return new Action(namespaceURI, localName, namespacePrefix);
        }

    }

    
    
    
}
