package org.openliberty.xmltooling.wsa;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.soapbinding.SecurityMechID;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * It may be necessary for an entity receiving an ID-* message to indicate the type of credentials that
 * should be used by the sender in submitting a message.
 * <p>
 * <pre>
 *     &lt;xs:complexType name="CredentialsContextType"&gt;
 *         &lt;xs:sequence&gt;
 *             &lt;xs:element ref="samlp:RequestedAuthnContext" minOccurs="0"/&gt;
 *             &lt;xs:element name="SecurityMechID" type="xs:anyURI" minOccurs="0" maxOccurs="unbounded"/&gt;
 *         &lt;/xs:sequence&gt;
 *         &lt;xs:anyAttribute namespace="##other" processContents="lax"/&gt;
 *     &lt;/xs:complexType&gt;
 * </pre>
 * </p>
 * 
 * @author asa
 *
 */
public class CredentialsContext extends AbstractSignableXMLObject implements AttributeExtensibleXMLObject
{
    
    public static final String LOCAL_NAME = "CredentialsContext";
    
    // Attributes
    private AttributeMap otherAttributes;
    
    // Elements
    private RequestedAuthnContext requestedAuthnContext;
    private XMLObjectChildrenList<SecurityMechID> securityMechIDs;
    
    protected CredentialsContext()
    {
        super(Konstantz.SB_NS, LOCAL_NAME, Konstantz.SB_PREFIX);
    }
        
    protected CredentialsContext(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public RequestedAuthnContext getRequestedAuthnContext()
    {
        return requestedAuthnContext;
    }

    public void setRequestedAuthnContext(RequestedAuthnContext requestedAuthnContext)
    {
        this.requestedAuthnContext = requestedAuthnContext;
    }
    
    /**
     * A set of elements that specify ID-WSF security mechanism URIs
     * 
     * @return
     */
    public XMLObjectChildrenList<SecurityMechID> getSecurityMechIDs()
    {
        return securityMechIDs;
    }

    public List<XMLObject> getOrderedChildren()
    {
        List<XMLObject> children = new LinkedList<XMLObject>();
        
        children.add(requestedAuthnContext);
        if(null!=securityMechIDs) children.addAll(securityMechIDs);

        return Collections.unmodifiableList(children);
    }

    public AttributeMap getUnknownAttributes()
    {   
        // lazy initialization
        if(null==otherAttributes) otherAttributes = new AttributeMap(this);
        return otherAttributes;
    }
    
    /**
     * Internal Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller 
    {

        /** {@inheritDoc} */
        @Override
		protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
        {
            CredentialsContext obj = (CredentialsContext) parentXMLObject;
                    
            if (childXMLObject instanceof RequestedAuthnContext) 
            {
                obj.setRequestedAuthnContext((RequestedAuthnContext) childXMLObject);
            }
            else if (childXMLObject instanceof SecurityMechID) 
            {
                obj.getSecurityMechIDs().add((SecurityMechID) childXMLObject);
            }

        }
        
        /** {@inheritDoc} */
        @Override
		protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
        {
            CredentialsContext obj = (CredentialsContext) xmlObject;
            QName attribQName = QNameSupport.constructQName(attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getPrefix());
            if (attribute.isId()) 
            {
                obj.getUnknownAttributes().registerID(attribQName);
            }
            obj.getUnknownAttributes().put(attribQName, attribute.getValue());
        }

        /** {@inheritDoc} */
        @Override
		protected void processElementContent(XMLObject xmlObject, String elementContent) 
        {
            // no element content
        }

    }

    
    /**
     * Internal Marshaller
     * 
     * @author asa
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller 
    {
        
        /** {@inheritDoc} */
        @Override
		protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            CredentialsContext obj = (CredentialsContext) xmlObject;

            Attr attribute;
            for (Entry<QName, String> entry : obj.getUnknownAttributes().entrySet())
            {
                attribute = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
                attribute.setValue(entry.getValue());
                domElement.setAttributeNodeNS(attribute);
                if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || obj.getUnknownAttributes().isIDAttribute(entry.getKey()))
                {
                    attribute.getOwnerElement().setIdAttributeNode(attribute, true);
                }
            }
        }

        /** {@inheritDoc} */
        @Override
		protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            // no element content
        }
    }
    
    
    
    /**
     * Internal Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<CredentialsContext>
    {
        @Override
        public CredentialsContext buildObject(String namespaceURI, String localName, String namespacePrefix)
        {            
            return new CredentialsContext(namespaceURI, localName, namespacePrefix);
        }        
    }
    
}
