package org.openliberty.xmltooling.wsa;

import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

public class EndpointReferenceUnmarshaller extends AbstractXMLObjectUnmarshaller
{

    
	@Override
	protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
	{
		EndpointReference epr = (EndpointReference) xmlObject;

        if (attribute.getLocalName().equals(EndpointReference.ATT_ID)) 
        {
        	epr.setId(attribute.getValue());
            attribute.getOwnerElement().setIdAttributeNode(attribute, true);
        }
        else if (attribute.getLocalName().equals(EndpointReference.ATT_NOT_ON_OR_AFTER)) 
        {
        	epr.setNotOnOrAfter(OpenLibertyHelpers.dateTimeForString(attribute.getValue()));
        }	        
	}

	
	@Override
	protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
	{	
		EndpointReference epr = (EndpointReference) parentXMLObject;		
		
        if (childXMLObject instanceof Address) 
        {
        	epr.setAddress((Address) childXMLObject);
        }
        else if(childXMLObject instanceof Metadata)
        {
        	epr.setMetadata((Metadata) childXMLObject);
        }
        else
        {
            epr.getUnknownXMLObjects().add(childXMLObject);
        }	
                
	}

	
	@Override
	protected void processElementContent(XMLObject xmlObject, String elementContent) 
	{
		// NO CONTENT
		// EndpointReference epr = (EndpointReference) xmlObject;        
		// epr.setValue(elementContent);
	}

}
