package org.openliberty.xmltooling.wsa;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;

/**
 * The <wsa:FaultTo> header block is defined in [WSAv1.0-SOAP]. The value of this header block, which is of the
 * WS-Addressing endpoint reference type, specifies the address to which a fault should be sent, if one should arise in
 * the processing of the message. If not present, faults are sent to the reply address.
 * <p>
 * <pre>
 *  &lt;xs:element name="FaultTo" type="tns:EndpointReferenceType"/&gt;
 * </pre>
 * @author asa
 *
 */
public class FaultTo extends EndpointReference
{

    public static final String LOCAL_NAME = "FaultTo";
    
    public FaultTo()
    {
        super(Konstantz.WSA_NS, LOCAL_NAME, Konstantz.WSA_PREFIX);
    }

    public FaultTo(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }  
    
    /**
     * Internal Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends EndpointReferenceUnmarshaller
    {
    }
    
    /**
     * Internal Marshaller
     * 
     * @author asa
     */
    public static class Marshaller extends EndpointReferenceMarshaller 
    {
    }
    
    
    /**
     * Internal Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<FaultTo>
    {
        @Override
        public FaultTo buildObject(String namespaceURI, String localName, String namespacePrefix)
        {            
            return new FaultTo(namespaceURI, localName, namespacePrefix);
        }        
    }

    
    
}
