package org.openliberty.xmltooling.wsa;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import javax.xml.namespace.QName;

import org.openliberty.xmltooling.Konstantz;
import org.openliberty.xmltooling.disco.MetadataAbstract;
import org.openliberty.xmltooling.disco.Options;
import org.openliberty.xmltooling.disco.ProviderID;
import org.openliberty.xmltooling.disco.SecurityContext;
import org.openliberty.xmltooling.disco.ServiceType;
import org.openliberty.xmltooling.soapbinding.Framework;
import org.opensaml.core.xml.ElementExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

public class Metadata  extends AbstractSignableXMLObject implements ElementExtensibleXMLObject 
{	

    public static final String LOCAL_NAME = "Metadata";	

    // Elements
    private MetadataAbstract abstrakt;                                 // MAY
    private ProviderID providerID;                                     // REQUIRED
    private XMLObjectChildrenList<ServiceType> serviceTypes;           // REQUIRED 1...n
    private XMLObjectChildrenList<Framework> frameworks;	           // REQUIRED 1...n    
    private XMLObjectChildrenList<Action> actions;                     // OPTIONAL
    private Options options;	                                       // OPTIONAL
    private XMLObjectChildrenList<SecurityContext> securityContexts;   // One or more SHOULD be present
    private IndexedXMLObjectChildrenList<XMLObject> unknownXMLObjects;

    public Metadata() 
    {
        super(Konstantz.WSA_NS, LOCAL_NAME, Konstantz.WSA_PREFIX);
        unknownXMLObjects = new IndexedXMLObjectChildrenList<XMLObject>(this);
        securityContexts = new XMLObjectChildrenList<SecurityContext>(this);
        frameworks = new XMLObjectChildrenList<Framework>(this);
        actions = new XMLObjectChildrenList<Action>(this);
        serviceTypes = new XMLObjectChildrenList<ServiceType>(this);
    }
    
    
    protected Metadata(String namespaceURI, String elementLocalName, String namespacePrefix) 
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        unknownXMLObjects = new IndexedXMLObjectChildrenList<XMLObject>(this);
        securityContexts = new XMLObjectChildrenList<SecurityContext>(this);
        frameworks = new XMLObjectChildrenList<Framework>(this);
        actions = new XMLObjectChildrenList<Action>(this);
        serviceTypes = new XMLObjectChildrenList<ServiceType>(this);
    }

    public void setMetadataAbstract(MetadataAbstract abstrakt)
    {
        this.abstrakt = abstrakt;
    }

    public MetadataAbstract getMetadataAbstract()
    {
        return this.abstrakt;
    }	

    public ProviderID getProviderID()
    {
        return providerID;
    }

    public void setProviderID(ProviderID providerID)
    {
        this.providerID = providerID;
    }

    /**
     * One or more &lt;ServiceType&gt; elements MUST be present in the EPR &lt;Metadata&gt; element.
     * 
     * @return
     */
    public List<ServiceType> getServiceTypes()
    {
        return serviceTypes;
    }

    /**
     * If the EPR holds a reference to the URN specified, then this method returns 
     * true.
     * 
     * @param urn
     * @return
     */
    public boolean referencesServiceTypeURN(String urn)
    {
        if(null!=urn)
        {
            for (ServiceType serviceType : getServiceTypes())
            {
                if(null!=serviceType.getValue() && serviceType.getValue().equals(urn)) return true;
            }        
        }
        return false;
    }


    /**
     * One or more &lt;Framework&gt; elements MUST be present in the EPR &lt;Metadata&gt; element.
     * 
     * @return
     */
    public XMLObjectChildrenList<Framework> getFrameworks()
    {
        return frameworks;
    }

    public XMLObjectChildrenList<Action> getActions()
    {
        return actions;
    }

    public Options getOptions()
    {
        return options;
    }

    public XMLObjectChildrenList<SecurityContext> getSecurityContexts()
    {
        return securityContexts;
    }

    public void setOptions(Options options)
    {
        this.options = options;
    }

    public List<XMLObject> getUnknownXMLObjects() 
    {
        return unknownXMLObjects;
    }

    @SuppressWarnings("unchecked")
    public List<XMLObject> getUnknownXMLObjects(QName typeOrName)
    {
        return (List<XMLObject>) unknownXMLObjects.subList(typeOrName);
    }

    public List<XMLObject> getOrderedChildren() 
    {
        List<XMLObject> children = new LinkedList<XMLObject>();

        children.add(abstrakt);
        children.add(providerID);
        children.addAll(serviceTypes);
        children.addAll(frameworks);
        children.addAll(securityContexts);
        children.addAll(actions);        
        children.add(options);
        children.addAll(unknownXMLObjects);

        return Collections.unmodifiableList(children);
    }

}
