package org.openliberty.xmltooling.wsa;

import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.soap.common.AbstractExtensibleSOAPObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * 
 * <pre>
 *  &lt;xs:complexType name="ReferenceParametersType" mixed="false"&gt;
 *      &lt;xs:sequence&gt;
 *          &lt;xs:any namespace="##any" processContents="lax" minOccurs="0" maxOccurs="unbounded"/&gt;
 *      &lt;/xs:sequence&gt;
 *      &lt;xs:anyAttribute namespace="##other" processContents="lax"/&gt;
 *  &lt;/xs:complexType&gt;
 * </pre>
 * @author asa
 *
 */
public class ReferenceParameters extends AbstractExtensibleSOAPObject
{
    public static final String LOCAL_NAME = "ReferenceParameters";
    
    
    public ReferenceParameters()
    {
        super(Konstantz.WSA_NS, LOCAL_NAME, Konstantz.WSA_PREFIX);
    }
    
    protected ReferenceParameters(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }
    
    
    
    

    /**
     * Internal Unmarshaller 
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller
    {

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
        {
            ReferenceParameters obj = (ReferenceParameters) xmlObject;
            
            QName attribQName = QNameSupport.getNodeQName(attribute);
            if (attribute.isId()) 
            {
                obj.getUnknownAttributes().registerID(attribQName);
            }
            obj.getUnknownAttributes().put(attribQName, attribute.getValue());
        }

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
        {
            ReferenceParameters obj = (ReferenceParameters) parentXMLObject;
            obj.getUnknownXMLObjects().add(childXMLObject);
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent) 
        {
            // no element content
        }

    }


    /**
     * Internal Marshaller 
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller 
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException
        {
            ReferenceParameters obj = (ReferenceParameters) xmlObject;             
            Attr attr;
            for(Entry<QName, String> entry: obj.getUnknownAttributes().entrySet())
            {
                attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
                attr.setValue(entry.getValue());
                domElement.setAttributeNodeNS(attr);

                if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || obj.getUnknownAttributes().isIDAttribute(entry.getKey())) 
                {
                    attr.getOwnerElement().setIdAttributeNode(attr, true);
                }
            }
        }

        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            // no content
        }

    }



    /**
     * Internal Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<ReferenceParameters>
    {
        @Override
        public ReferenceParameters buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new ReferenceParameters(namespaceURI, localName, namespacePrefix);
        }        
    }


    
}
