package org.openliberty.xmltooling.wsa;

import java.util.List;
import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;


/**
 * The &lt;wsa:RelatesTo&gt; header block is defined in [WSAv1.0-SOAP]. The value of this header block establishes a
 * relationship between the message that contains it and some other message. The type of relationship is specified in the
 * RelationshipType attribute.
 * <p>
 * Decided not to directly support RelationshipType other than through the unknownAttributes map.  The
 * default usage of RelatesTo Header is as a RelationshipType: http://www.w3.org/2005/03/addressing/reply
 * 
 * <pre>
 *  &lt;xs:element name="RelatesTo" type="tns:RelatesToType"/&gt;
 *  &lt;xs:complexType name="RelatesToType"&gt;
 *      &lt;xs:simpleContent&gt;
 *          &lt;xs:extension base="xs:anyURI"&gt;
 *              &lt;xs:attribute name="RelationshipType" type="tns:RelationshipTypeOpenEnum"
 *                  use="optional" default="&nsuri;/reply"/&gt;
 *              &lt;xs:anyAttribute namespace="##other" processContents="lax"/&gt;
 *          &lt;/xs:extension&gt;
 *      &lt;/xs:simpleContent&gt;
 *  &lt;/xs:complexType&gt;
 *  
 *  &lt;xs:simpleType name="RelationshipTypeOpenEnum"&gt;
 *      &lt;xs:union memberTypes="tns:RelationshipType xs:anyURI"/&gt;
 *  &lt;/xs:simpleType&gt;
 *  
 *  &lt;xs:simpleType name="RelationshipType"&gt;
 *      &lt;xs:restriction base="xs:anyURI"&gt;
 *          &lt;xs:enumeration value="&nsuri;/reply"/&gt;
 *      &lt;/xs:restriction&gt;
 *  &lt;/xs:simpleType&gt;
 * </pre>
 * </p>
 * @author asa
 *
 */
public class RelatesTo extends AbstractSignableXMLObject implements AttributeExtensibleXMLObject 
{
    public static final String LOCAL_NAME = "RelatesTo";

    private String value;
    
    /**
     * Support for AttributeExtensibleXMLObject interface
     */
    private AttributeMap otherAttributes;

    /**
     * &nsuri;/reply  
     * 
     * When the relationship is http://www.w3.org/2005/03/addressing/reply, the RelationshipType attribute may be omitted.
     * 
     */
    // private String relationshipType;
    
    public static final String ATT_RELATIONSHIP_TYPE = "RelationshipType";
    
    public RelatesTo()
    {
        super(Konstantz.WSA_NS, LOCAL_NAME, Konstantz.WSA_PREFIX);
        otherAttributes = new AttributeMap(this);
    }
    
    protected RelatesTo(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
        otherAttributes = new AttributeMap(this);
    }

    
    public String getValue()
    {
        return value;
    }

    public void setValue(String value)
    {
        this.value = prepareForAssignment(this.value, value);
    }

    public AttributeMap getUnknownAttributes()
    {
        return otherAttributes;
    }

    public List<XMLObject> getOrderedChildren()
    {
        // no children
        return null;
    }

    
    /**
     * Internal Unmarshaller 
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller 
    {

        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
        {
            RelatesTo relatesTo = (RelatesTo) xmlObject;
            QName attribQName = QNameSupport.getNodeQName(attribute);
            if (attribute.isId()) 
            {
                relatesTo.getUnknownAttributes().registerID(attribQName);
            }
            relatesTo.getUnknownAttributes().put(attribQName, attribute.getValue());
        }

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
        {
            // no children
        }

        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent) 
        {
            RelatesTo relatesTo = (RelatesTo) xmlObject;
            
            if(elementContent != null)
            {
                relatesTo.setValue(elementContent.trim());
            }
        }
        
    }
    
    
    /**
     * Internal Marshaller 
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller 
    {

        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            RelatesTo relatesTo = (RelatesTo) xmlObject;             
            Attr attr;
            for(Entry<QName, String> entry: relatesTo.getUnknownAttributes().entrySet())
            {
                attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
                attr.setValue(entry.getValue());
                domElement.setAttributeNodeNS(attr);
                
                if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || relatesTo.getUnknownAttributes().isIDAttribute(entry.getKey())) 
                {
                    attr.getOwnerElement().setIdAttributeNode(attr, true);
                }
            }
        }


        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            RelatesTo relatesTo = (RelatesTo) xmlObject;
            ElementSupport.appendTextContent(domElement, relatesTo.getValue());
        }

    }

    
    
    /**
     * Internal Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<RelatesTo>
    {
        @Override
        public RelatesTo buildObject(String namespaceURI, String localName, String namespacePrefix)
        {
            return new RelatesTo(namespaceURI, localName, namespacePrefix);
        }        
    }
    
    
}
