package org.openliberty.xmltooling.wsa;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;

/**
 * The &lt;wsa:ReplyTo&gt; header block is defined in [WSAv1.0-SOAP]. The value of this header block, which is of the
 * WS-Addressing endpoint reference type, specifies the address to which a reply should be sent.
 * <p>
 * <pre>
 *  &lt;xs:element name="ReplyTo" type="tns:EndpointReferenceType"/&gt;
 * </pre>
 * @author asa
 *
 */
public class ReplyTo extends EndpointReference
{

    public static final String LOCAL_NAME = "ReplyTo";
    
    public ReplyTo()
    {
        super(Konstantz.WSA_NS, LOCAL_NAME, Konstantz.WSA_PREFIX);
    }

    public ReplyTo(String namespaceURI, String elementLocalName, String namespacePrefix)
    {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }  
    
    /**
     * Internal Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends EndpointReferenceUnmarshaller
    {
    }
    
    /**
     * Internal Marshaller
     * 
     * @author asa
     */
    public static class Marshaller extends EndpointReferenceMarshaller 
    {
    }
    
    
    /**
     * Internal Builder
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<ReplyTo>
    {
        @Override
        public ReplyTo buildObject(String namespaceURI, String localName, String namespacePrefix)
        {            
            return new ReplyTo(namespaceURI, localName, namespacePrefix);
        }        
    }

    
    
}
