/**
 * 
 */
package org.openliberty.xmltooling.wsa;

import java.util.List;
import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.ElementSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * 
 * In the typical case that a WS-Addressing endpoint reference is used to address a message, the value of this header
 * block is taken from the &lt;wsa:Address&gt; of the {@link EndpointReference}. If the &lt;wsa:To&gt; header block is not present,
 * the value defaults to http://www.w3.org/2005/03/addressing/role/anonymous; so, when constructing a message, the
 * header block can be omitted if this is the value that would be used. This typically allows the &lt;wsa:To&gt; header block
 * to be omitted during synchronous request-response message exchanges over HTTP. Please refer to [WSAv1.0] for
 * default processing rules in the absence of the &lt;wsa:To&gt; header block.
 * 
 * @author tguion
 * @author asa
 */
public class To extends AbstractSignableXMLObject implements AttributeExtensibleXMLObject 
{

    /** Local name of the SASL type. */
    public static final String DEFAULT_ELEMENT_LOCAL_NAME = "To"; 

    /** Default element name. */
    public static final QName DEFAULT_ELEMENT_NAME = QNameSupport.constructQName(Konstantz.WSA_NS, DEFAULT_ELEMENT_LOCAL_NAME, Konstantz.WSA_PREFIX);

    /** Content: AttributedURIType */
    private String value;

    /**
     * Support for AttributeExtensibleXMLObject interface
     */
    private AttributeMap otherAttributes;

    /**
     * Constructor
     *
     */
    public To() 
    {
        super(Konstantz.WSA_NS, DEFAULT_ELEMENT_LOCAL_NAME, Konstantz.WSA_PREFIX);
    }

    /**
     * Constructor
     * 
     * @param namespaceURI the namespace the element is in
     * @param elementLocalName the local name of the XML element this Object represents
     * @param namespacePrefix the prefix for the given namespace
     */
    protected To(String namespaceURI, String elementLocalName, String namespacePrefix) 
    {
        super(namespaceURI, elementLocalName, namespacePrefix);		
    }

    /**
     * {@inheritDoc}
     */
    public String getValue() 
    {
        return value;
    }

    /**
     * {@inheritDoc}
     */
    public void setValue(String newValue) 
    {
        value = prepareForAssignment(value, newValue);
    }

    /* (non-Javadoc)
     * @see org.opensaml.xml.AttributeExtensibleXMLObject#getUnknownAttributes()
     */
    public AttributeMap getUnknownAttributes() 
    {
        if(null==otherAttributes) otherAttributes = new AttributeMap(this);
        return otherAttributes;
    }

    /* (non-Javadoc)
     * @see org.opensaml.xml.XMLObject#getOrderedChildren()
     */
    public List<XMLObject> getOrderedChildren() 
    {
        return null;
    }


    /**
     * Static Internal Unmarshaller
     * 
     * @author asa
     *
     */
    public static class Unmarshaller extends AbstractXMLObjectUnmarshaller 
    {

        /* (non-Javadoc)
         * @see org.opensaml.xml.io.AbstractXMLObjectUnmarshaller#processAttribute(org.opensaml.xml.XMLObject, org.w3c.dom.Attr)
         */
        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
        {
            To obj = (To) xmlObject;
            QName attribQName = QNameSupport.getNodeQName(attribute);
            if (attribute.isId()) 
            {
                obj.getUnknownAttributes().registerID(attribQName);
            }
            obj.getUnknownAttributes().put(attribQName, attribute.getValue());
        }

        /* (non-Javadoc)
         * @see org.opensaml.xml.io.AbstractXMLObjectUnmarshaller#processChildElement(org.opensaml.xml.XMLObject, org.opensaml.xml.XMLObject)
         */
        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
        {
            // no children
        }

        /* (non-Javadoc)
         * @see org.opensaml.xml.io.AbstractXMLObjectUnmarshaller#processElementContent(org.opensaml.xml.XMLObject, java.lang.String)
         */
        @Override
        protected void processElementContent(XMLObject xmlObject, String elementContent) 
        {
            To obj = (To) xmlObject;

            if(elementContent != null)
            {
                obj.setValue(elementContent.trim());
            }
        }

    }


    /**
     * Static internal Marshaller 
     * 
     * @author asa
     *
     */
    public static class Marshaller extends AbstractXMLObjectMarshaller 
    {

        /* (non-Javadoc)
         * @see org.opensaml.xml.io.AbstractXMLObjectMarshaller#marshallAttributes(org.opensaml.xml.XMLObject, org.w3c.dom.Element)
         */
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            To obj = (To) xmlObject; 

            Attr attr;
            for(Entry<QName, String> entry: obj.getUnknownAttributes().entrySet())
            {
                attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
                attr.setValue(entry.getValue());
                domElement.setAttributeNodeNS(attr);
                if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || obj.getUnknownAttributes().isIDAttribute(entry.getKey())) 
                {
                    attr.getOwnerElement().setIdAttributeNode(attr, true);
                }
            }
        }

        /* (non-Javadoc)
         * @see org.opensaml.xml.io.AbstractXMLObjectMarshaller#marshallElementContent(org.opensaml.xml.XMLObject, org.w3c.dom.Element)
         */
        @Override
        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException 
        {
            To obj = (To) xmlObject;
            ElementSupport.appendTextContent(domElement, obj.getValue());
        }

    }


    /**
     * 
     * @author asa
     *
     */
    public static class Builder extends AbstractXMLObjectBuilder<To> 
    {
        /*
         * (non-Javadoc)
         * 
         * @see org.opensaml.xml.AbstractXMLObjectBuilder#buildObject(java.lang.String,
         *      java.lang.String, java.lang.String)
         */
        @Override
        public To buildObject(String namespaceURI, String localName, String namespacePrefix) 
        {
            return new To(namespaceURI, localName, namespacePrefix);
        }

    }




}
