/**
 * 
 */
package org.openliberty.xmltooling.wsse;

import java.util.Collections;
import java.util.List;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.ElementExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

/**
 * @author tguion
 *
 */
public class Security extends AbstractSignableXMLObject implements ElementExtensibleXMLObject, AttributeExtensibleXMLObject {

	   /** Local name of the SASL type. */
    public static final String DEFAULT_ELEMENT_LOCAL_NAME = "Security"; 
        
    /** Default element name. */
    public static final QName DEFAULT_ELEMENT_NAME = QNameSupport.constructQName(Konstantz.WSSE_NS, DEFAULT_ELEMENT_LOCAL_NAME, Konstantz.WSSE_PREFIX);
    
	/**
	 * Support for ElementExtensibleXMLObject interface
	 */
	private IndexedXMLObjectChildrenList<XMLObject> unknownChildren;
	
	/**
	 * Support for AttributeExtensibleXMLObject interface
	 */
	private AttributeMap otherAttributes;
	
	private String value;
	
	protected Security(String namespaceURI, String elementLocalName, String namespacePrefix) 
	{
		super(namespaceURI, elementLocalName, namespacePrefix);
		unknownChildren = new IndexedXMLObjectChildrenList<XMLObject>(this);
		otherAttributes = new AttributeMap(this);
	}
	
	
    public String getValue() 
    {
        return value;
    }

    public void setValue(String newValue) 
    {
        value = prepareForAssignment(value, newValue);
    }	
	
	/* (non-Javadoc)
	 * @see org.opensaml.xml.ElementExtensibleXMLObject#getUnknownXMLObjects()
	 */
	public List<XMLObject> getUnknownXMLObjects() 
	{
		return unknownChildren;
	}

    @SuppressWarnings("unchecked")
    public List<XMLObject> getUnknownXMLObjects(QName typeOrName)
    {
        return (List<XMLObject>) unknownChildren.subList(typeOrName);
    }
    
	/* (non-Javadoc)
	 * @see org.opensaml.xml.XMLObject#getOrderedChildren()
	 */
	public List<XMLObject> getOrderedChildren() 
	{
		return Collections.unmodifiableList(unknownChildren);
	}

	/* (non-Javadoc)
	 * @see org.opensaml.xml.AttributeExtensibleXMLObject#getUnknownAttributes()
	 */
	public AttributeMap getUnknownAttributes() 
	{
		return otherAttributes;
	}

}
