/**
 * 
 */
package org.openliberty.xmltooling.wsse;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

/**
 * @author tguion
 *
 */
public class SecurityUnmarshaller extends AbstractXMLObjectUnmarshaller {

    /* (non-Javadoc)
     * @see org.opensaml.xml.io.AbstractXMLObjectUnmarshaller#processAttribute(org.opensaml.xml.XMLObject, org.w3c.dom.Attr)
     */
    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute)
    throws UnmarshallingException {
        Security security = (Security) xmlObject;
        QName attribQName = QNameSupport.getNodeQName(attribute);
        if (attribute.isId()) {
            security.getUnknownAttributes().registerID(attribQName);
        }
        security.getUnknownAttributes().put(attribQName, attribute.getValue());
    }

    /* (non-Javadoc)
     * @see org.opensaml.xml.io.AbstractXMLObjectUnmarshaller#processChildElement(org.opensaml.xml.XMLObject, org.opensaml.xml.XMLObject)
     */
    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
    {
        Security security = (Security) parentXMLObject;

        security.getUnknownXMLObjects().add(childXMLObject);
    }

    /* (non-Javadoc)
     * @see org.opensaml.xml.io.AbstractXMLObjectUnmarshaller#processElementContent(org.opensaml.xml.XMLObject, java.lang.String)
     */
    @Override
	protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {
        Security security = (Security) xmlObject;

        if(elementContent != null)
        {
            security.setValue(elementContent.trim());
        }
    }	




}
