/**
 * 
 */
package org.openliberty.xmltooling.wsu;

import java.util.List;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

/**
 * @author tguion
 *
 */
public class AttributedDateTime extends AbstractSignableXMLObject implements CommonAtts 
{

    // TODO: model this as a DateTime
	private String value;

    public static final String ATT_ID = "Id";
    
	/**
     * wsu:Id attribute specified in commonAtts 
	 */
	private String id; // wsu:Id (XS:ID)
    
	private AttributeMap otherAttributes;
	
	protected AttributedDateTime(String namespaceURI, String elementLocalName, String namespacePrefix) 
	{
		super(namespaceURI, elementLocalName, namespacePrefix);	
		otherAttributes = new AttributeMap(this);
	}
	       
    public String getValue() 
    { 
    	return value; 
    }
    
    public void setValue(String value) 
    {
    	this.value = prepareForAssignment(this.value, value);
    }
    
    
    public String getId()
    {
        return id;
    }

    public void setId(String id)
    {
        this.id = prepareForAssignment(this.id, id);        
    }
    
    
	/* (non-Javadoc)
	 * @see org.opensaml.xml.AttributeExtensibleXMLObject#getUnknownAttributes()
	 */
	public AttributeMap getUnknownAttributes() 
    {
		return otherAttributes;
	}

	/* (non-Javadoc)
	 * @see org.opensaml.xml.XMLObject#getOrderedChildren()
	 */
	public List<XMLObject> getOrderedChildren() 
    {
		return null;
	}




}
