/**
 * 
 */
package org.openliberty.xmltooling.wsu;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

/**
 * @author tguion
 *
 */
public class AttributedDateTimeUnmarshaller extends AbstractXMLObjectUnmarshaller 
{

    /* (non-Javadoc)
     * @see org.opensaml.xml.io.AbstractXMLObjectUnmarshaller#processAttribute(org.opensaml.xml.XMLObject, org.w3c.dom.Attr)
     */
    @Override
    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException 
    {
        
        AttributedDateTime obj = (AttributedDateTime)xmlObject;
        
        if (attribute.getLocalName().equals(AttributedDateTime.ATT_ID)) 
        {
            obj.setId(attribute.getValue());
        }
        else
        {
            AttributedDateTime adt = (AttributedDateTime) xmlObject;
            QName attribQName = QNameSupport.getNodeQName(attribute);
            if (attribute.isId()) 
            {
                adt.getUnknownAttributes().registerID(attribQName);
            }
            adt.getUnknownAttributes().put(attribQName, attribute.getValue());
        }
    }

    
    /* (non-Javadoc)
     * @see org.opensaml.xml.io.AbstractXMLObjectUnmarshaller#processChildElement(org.opensaml.xml.XMLObject, org.opensaml.xml.XMLObject)
     */
    @Override
    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException 
    {
        // no children to process
    }

    
    /* (non-Javadoc)
     * @see org.opensaml.xml.io.AbstractXMLObjectUnmarshaller#processElementContent(org.opensaml.xml.XMLObject, java.lang.String)
     */
    @Override
    protected void processElementContent(XMLObject xmlObject, String elementContent) 
    {
        AttributedDateTime adt = (AttributedDateTime) xmlObject;
        adt.setValue(elementContent);
    }

}
