package org.openliberty.xmltooling.wsu;

import org.opensaml.core.xml.AttributeExtensibleXMLObject;

/**
 * This is a convenience attribute group that simplifies 
 * the wss utility schema.
 * 
 * <pre>
 *  &lt;xsd:attributeGroup name="commonAtts"&gt;
 *      &lt;xsd:annotation&gt;
 *          &lt;xsd:documentation&gt;
 * Convenience attribute group used to simplify this schema.
 *           &lt;/xsd:documentation&gt;
 *      &lt;/xsd:annotation&gt;
 *      &lt;xsd:attribute ref="wsu:Id" use="optional"/&gt;
 *      &lt;xsd:anyAttribute namespace="##other" processContents="lax"/&gt;
 *  &lt;/xsd:attributeGroup&gt;
 * </pre>
 * @author asa
 *
 */
public interface CommonAtts extends AttributeExtensibleXMLObject 
{
    public String getId();
    public void setId(String Id);
}
