/**
 * 
 */
package org.openliberty.xmltooling.wsu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.xml.namespace.QName;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.ElementExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;

/**
 * @author tguion
 *
 */
public class Timestamp extends AbstractSignableXMLObject implements ElementExtensibleXMLObject, AttributeExtensibleXMLObject {

	public static String DEFAULT_ELEMENT_LOCAL_NAME = "Timestamp";

    /** Default element name. */
    public static final QName DEFAULT_ELEMENT_NAME = new QName(Konstantz.WSU_NS, DEFAULT_ELEMENT_LOCAL_NAME, Konstantz.WSU_PREFIX);
	
    /** Name for the attribute which defines the Id. */
    public final static String ID_ATTRIB_NAME = "Id";
    
    private String id;
    
    private Created created;
    
    private Expires expires;
    
    /**
	 * Support for ElementExtensibleXMLObject interface
	 */
	private IndexedXMLObjectChildrenList<XMLObject> unknownChildren;
	
	/**
	 * Support for AttributeExtensibleXMLObject interface
	 */
	private AttributeMap otherAttributes;
	
	protected Timestamp(String namespaceURI, String elementLocalName, String namespacePrefix) 
	{
		super(namespaceURI, elementLocalName, namespacePrefix);	
		unknownChildren = new IndexedXMLObjectChildrenList<XMLObject>(this);
		otherAttributes = new AttributeMap(this);
	}
	
	/* (non-Javadoc)
	 * @see org.opensaml.xml.ElementExtensibleXMLObject#getUnknownXMLObjects()
	 */
	public List<XMLObject> getUnknownXMLObjects() {
		return unknownChildren;
	}

    @SuppressWarnings("unchecked")
    public List<XMLObject> getUnknownXMLObjects(QName typeOrName)
    {
        return (List<XMLObject>) unknownChildren.subList(typeOrName);
    }
    
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.opensaml.xml.XMLObject#getOrderedChildren()
	 */
	public List<XMLObject> getOrderedChildren() {
		ArrayList<XMLObject> children = new ArrayList<XMLObject>();
		
		// Created, Expires
		if(null!=created) children.add(created);
		if(null!=expires) children.add(expires);
		children.addAll(unknownChildren);

		return Collections.unmodifiableList(children);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.opensaml.xml.AttributeExtensibleXMLObject#getUnknownAttributes()
	 */
	public AttributeMap getUnknownAttributes() 
	{
		return otherAttributes;
	}

	/**
	 * @return the created
	 */
	public Created getCreated() 
	{
		return created;
	}

	/**
	 * @param created the created to set
	 */
	public void setCreated(Created created) 
	{
		this.created = created;
	}

	/**
	 * @return the expires
	 */
	public Expires getExpires() 
	{
		return expires;
	}

	/**
	 * @param expires the expires to set
	 */
	public void setExpires(Expires expires) 
	{
		this.expires = expires;
	}

	/**
	 * @return the id
	 */
	public String getId() 
	{
		return id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(String id) 
	{
		this.id = id;
	}

}
