/**
 * 
 */
package org.openliberty.xmltooling.wsu;

import java.util.Map.Entry;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.AttributeSupport;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/**
 * @author tguion
 *
 */
public class TimestampMarshaller extends AbstractXMLObjectMarshaller {

	/* (non-Javadoc)
	 * @see org.opensaml.xml.io.AbstractXMLObjectMarshaller#marshallAttributes(org.opensaml.xml.XMLObject, org.w3c.dom.Element)
	 */
	@Override
	protected void marshallAttributes(XMLObject xmlObject, Element domElement)
			throws MarshallingException {
		Timestamp ts = (Timestamp) xmlObject;

		if(ts.getId() != null) 
		{
			domElement.setAttributeNS(Konstantz.WSU_NS, Timestamp.ID_ATTRIB_NAME, ts.getId());
		}	
		
        Attr attr;
        for(Entry<QName, String> entry: ts.getUnknownAttributes().entrySet()){
            attr = AttributeSupport.constructAttribute(domElement.getOwnerDocument(), entry.getKey());
            attr.setValue(entry.getValue());
            domElement.setAttributeNodeNS(attr);
            if (XMLObjectProviderRegistrySupport.isIDAttribute(entry.getKey()) || ts.getUnknownAttributes().isIDAttribute(entry.getKey())) {
                attr.getOwnerElement().setIdAttributeNode(attr, true);
            }
        }
	}

	/* (non-Javadoc)
	 * @see org.opensaml.xml.io.AbstractXMLObjectMarshaller#marshallElementContent(org.opensaml.xml.XMLObject, org.w3c.dom.Element)
	 */
	@Override
	protected void marshallElementContent(XMLObject xmlObject,
			Element domElement) throws MarshallingException {
		// no text content
	}

}
