/**
 * 
 */
package org.openliberty.xmltooling.wsu;

import javax.xml.namespace.QName;

import net.shibboleth.utilities.java.support.xml.QNameSupport;

import org.openliberty.xmltooling.Konstantz;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.w3c.dom.Attr;

/**
 * @author tguion
 *
 */
public class TimestampUnmarshaller extends AbstractXMLObjectUnmarshaller {

	/* (non-Javadoc)
	 * @see org.opensaml.xml.io.AbstractXMLObjectUnmarshaller#processAttribute(org.opensaml.xml.XMLObject, org.w3c.dom.Attr)
	 */
	@Override
	protected void processAttribute(XMLObject xmlObject, Attr attribute)
			throws UnmarshallingException {
		Timestamp ts = (Timestamp) xmlObject;
		if (attribute.getLocalName().equals(Timestamp.ID_ATTRIB_NAME) && Konstantz.WSU_NS.equals(attribute.getNamespaceURI())) {
            ts.setId(attribute.getValue());
            attribute.getOwnerElement().setIdAttributeNode(attribute, true);
        } else {
            QName attribQName = QNameSupport.getNodeQName(attribute);
            if (attribute.isId()) {
               ts.getUnknownAttributes().registerID(attribQName);
            }
            ts.getUnknownAttributes().put(attribQName, attribute.getValue());
        }
	}

	/* (non-Javadoc)
	 * @see org.opensaml.xml.io.AbstractXMLObjectUnmarshaller#processChildElement(org.opensaml.xml.XMLObject, org.opensaml.xml.XMLObject)
	 */
	@Override
	protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException {
		Timestamp ts = (Timestamp) parentXMLObject;

	        if (childXMLObject instanceof Created) {
	            ts.setCreated((Created) childXMLObject);
	        } else if (childXMLObject instanceof Expires) {
	            ts.setExpires((Expires) childXMLObject);
	        } else {
	            ts.getUnknownXMLObjects().add(childXMLObject);
	        }
	}

	/* (non-Javadoc)
	 * @see org.opensaml.xml.io.AbstractXMLObjectUnmarshaller#processElementContent(org.opensaml.xml.XMLObject, java.lang.String)
	 */
	@Override
	protected void processElementContent(XMLObject xmlObject,
			String elementContent) {
		// No text content
	}

}
