/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.wsc;

import java.net.URL;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;
import org.apache.xml.security.utils.Base64;
import org.openliberty.wsc.BaseServiceClient;
import org.openliberty.wsc.DiscoveryService;
import org.openliberty.wsc.WSCException;
import org.openliberty.wsc.WSFMessage;
import org.openliberty.xmltooling.sasl.Data;
import org.openliberty.xmltooling.sasl.DataBuilder;
import org.openliberty.xmltooling.sasl.SASLRequest;
import org.openliberty.xmltooling.sasl.SASLRequestBuilder;
import org.openliberty.xmltooling.sasl.SASLResponse;
import org.openliberty.xmltooling.soap.soap11.HeaderIDWSF;
import org.openliberty.xmltooling.utility_2_0.Status;
import org.openliberty.xmltooling.wsa.Address;
import org.openliberty.xmltooling.wsa.EndpointReference;
import org.openliberty.xmltooling.wsa.MessageID;
import org.openliberty.xmltooling.wsa.RelatesTo;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.soap.soap11.Envelope;

public class AuthenticationService
extends BaseServiceClient {
    private static Logger log = Logger.getLogger(AuthenticationService.class);
    boolean promiscuousMode = false;
    private URL serviceURL = null;
    private ResponseCode lastResponseCode;
    private String lastMessageId;

    public AuthenticationService(DiscoveryService discoveryService, EndpointReference initialEndpointReference) {
        super(discoveryService, initialEndpointReference);
    }

    public static AuthenticationService serviceForEndpointReference(DiscoveryService discoveryService, EndpointReference epr) {
        AuthenticationService service = null;
        try {
            service = new AuthenticationService(discoveryService, epr);
            service.setServiceURL(new URL(epr.getAddress().getValue()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return service;
    }

    public void setServiceURL(URL serviceURL) {
        this.serviceURL = serviceURL;
    }

    public ResponseCode getLastResponseCode() {
        return this.lastResponseCode;
    }

    public boolean isPromiscuousMode() {
        return this.promiscuousMode;
    }

    public void setPromiscuousMode(boolean promiscuousMode) {
        this.promiscuousMode = promiscuousMode;
    }

    public EndpointReference authenticate(String username, String password, AuthMechanism mechanism) throws WSCException {
        return this.authenticate(username, password, mechanism, null);
    }

    public EndpointReference authenticate(String username, String password, AuthMechanism mechanism, RequestedAuthnContext requestedAuthnContext) throws WSCException {
        this.lastMessageId = null;
        this.lastResponseCode = null;
        if (AuthMechanism.PLAIN == mechanism) {
            return this.authenticatePLAIN(username, password, requestedAuthnContext);
        }
        if (AuthMechanism.CRAM_MD5 == mechanism) {
            return this.authenticateCRAM_MD5(username, password, requestedAuthnContext);
        }
        throw new WSCException("");
    }

    public EndpointReference authenticatePLAIN(String username, String password, RequestedAuthnContext requestedAuthnContext) throws WSCException {
        if (username == null || password == null) {
            throw new WSCException(WSCExceptionType.ILLEGAL_ARGUMENTS.shortDesc + "Both username and password are required.");
        }
        boolean isDebug = log.isDebugEnabled();
        if (isDebug) {
            log.debug((Object)("AS: authenticatePLAIN(username " + username + ", password " + password + ")"));
        }
        SASLRequest request = new SASLRequestBuilder().buildObject();
        request.setMechanism(AuthMechanism.PLAIN.code);
        request.setRequestedAuthnContext(requestedAuthnContext);
        Data data = new DataBuilder().buildObject();
        String base64AuthToken = Base64.encode((byte[])('\u0000' + username + '\u0000' + password).getBytes());
        data.setValue(base64AuthToken);
        request.setData(data);
        SASLResponse response = this.invokeSASLRequest(this.serviceURL, request);
        ResponseCode responseCode = ResponseCode.getResponseCode(response);
        if (isDebug) {
            log.debug((Object)("     STATUS CODE: " + responseCode.codeValue));
        }
        EndpointReference epr = null;
        if (ResponseCode.OK == responseCode) {
            this.lastResponseCode = responseCode;
            epr = response.getEndpointReference();
            if (isDebug) {
                log.debug((Object)"     Authentication completed successfully.");
            }
        } else if (ResponseCode.ABORT == responseCode) {
            this.lastResponseCode = responseCode;
            if (isDebug) {
                log.debug((Object)"     Authentication aborted.");
            }
        } else if (ResponseCode.CONTINUE == responseCode) {
            this.lastResponseCode = responseCode;
            response.getStatus();
            throw new WSCException(WSCExceptionType.CONTINUE_NOT_SUPPORTED_IN_AUTHENTICATE_CONTEXT.shortDesc);
        }
        return epr;
    }

    public EndpointReference authenticateCRAM_MD5(String username, String password, RequestedAuthnContext requestedAuthnContext) throws WSCException {
        if (username == null || password == null) {
            throw new WSCException(WSCExceptionType.ILLEGAL_ARGUMENTS.shortDesc + "Both username and password are required.");
        }
        boolean isDebug = log.isDebugEnabled();
        SASLRequestBuilder requestBuilder = new SASLRequestBuilder();
        String challenge = null;
        SASLRequest stage1Request = requestBuilder.buildObject();
        stage1Request.setMechanism(AuthMechanism.CRAM_MD5.code);
        SASLResponse stage1Response = this.invokeSASLRequest(this.serviceURL, stage1Request);
        AuthMechanism serverMechanism = AuthMechanism.findAuthMechanism(stage1Response.getServerMechanism());
        if (AuthMechanism.CRAM_MD5 != serverMechanism) {
            if (this.promiscuousMode) {
                return this.authenticatePLAIN(username, password, requestedAuthnContext);
            }
            throw new WSCException(WSCExceptionType.UNEXPECTED_SERVER_AUTH_MECHANISM.shortDesc);
        }
        if (ResponseCode.CONTINUE != this.lastResponseCode) {
            throw new WSCException(WSCExceptionType.UNEXPECTED_STATUS_CODE.shortDesc);
        }
        if (null == stage1Response.getData()) {
            throw new WSCException(WSCExceptionType.NO_DATA_IN_SASL_RESPONSE.shortDesc);
        }
        challenge = stage1Response.getData().getValue();
        if (null == challenge) {
            throw new WSCException(WSCExceptionType.CRAM_MD5_CHALLENGE_IS_EMPTY.shortDesc);
        }
        StringBuffer buff = new StringBuffer();
        try {
            buff.append(username).append(' ');
            SecretKeySpec key = new SecretKeySpec(challenge.getBytes(), "HmacMD5");
            Mac mac = Mac.getInstance(key.getAlgorithm());
            mac.init(key);
            byte[] digest = mac.doFinal(password.getBytes());
            buff.append(Hex.encodeHex((byte[])digest));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(buff);
        Data data = new DataBuilder().buildObject();
        data.setValue(Base64.encode((byte[])buff.toString().getBytes()));
        SASLRequest stage2Request = requestBuilder.buildObject();
        stage2Request.setMechanism(AuthMechanism.CRAM_MD5.code);
        stage2Request.setData(data);
        stage2Request.setRequestedAuthnContext(requestedAuthnContext);
        SASLResponse stage2Response = this.invokeSASLRequest(this.serviceURL, stage2Request);
        if (isDebug) {
            log.debug((Object)("     STATUS CODE: " + this.lastResponseCode.codeValue));
        }
        EndpointReference epr = null;
        if (ResponseCode.OK == this.lastResponseCode) {
            epr = stage2Response.getEndpointReference();
            if (isDebug) {
                log.debug((Object)"     Authentication completed successfully.");
            }
        } else if (ResponseCode.ABORT == this.lastResponseCode) {
            if (isDebug) {
                log.debug((Object)"     Authentication aborted.");
            }
        } else if (ResponseCode.CONTINUE == this.lastResponseCode) {
            throw new WSCException(WSCExceptionType.CONTINUE_NOT_SUPPORTED_IN_AUTHENTICATE_CONTEXT.shortDesc);
        }
        return epr;
    }

    private SASLResponse invokeSASLRequest(URL addressURL, SASLRequest request) throws WSCException {
        boolean isDebug = log.isDebugEnabled();
        Address address = new Address();
        address.setValue(addressURL.toString());
        EndpointReference epr = new EndpointReference();
        epr.setAddress(address);
        WSFMessage message = null;
        try {
            message = WSFMessage.createWSFMessage(this, "urn:liberty:sa:2006-08:SASLRequest");
        }
        catch (XMLParserException e1) {
            e1.printStackTrace();
            return null;
        }
        catch (UnmarshallingException e1) {
            e1.printStackTrace();
            return null;
        }
        message.getRequestEnvelope().getBody().getUnknownXMLObjects().add(request);
        if (ResponseCode.CONTINUE == this.lastResponseCode && null != this.lastMessageId) {
            RelatesTo relatesTo = new RelatesTo();
            relatesTo.setValue(this.lastMessageId);
            message.addWSUIdAttribute(relatesTo, "relHdr");
            message.addSOAP11Attributes(relatesTo, true);
            ((HeaderIDWSF)message.getRequestEnvelope().getHeader()).setRelatesTo(relatesTo);
        }
        if (isDebug) {
            log.debug((Object)("SASL REQUEST\n" + WSFMessage.prettyPrintRequestMessage(message)));
        }
        try {
            message.invoke();
            if (isDebug) {
                log.debug((Object)("SASL RESPONSE\n" + WSFMessage.prettyPrintResponseMessage(message)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WSCException(WSCExceptionType.AUTHENTICATION_SERVICE_INVOCATION_FAILURE.shortDesc);
        }
        Envelope envelope = message.getResponseEnvelope();
        SASLResponse response = null;
        for (XMLObject object : envelope.getBody().getUnknownXMLObjects()) {
            if (!(object instanceof SASLResponse)) continue;
            response = (SASLResponse)object;
            break;
        }
        if (null == response) {
            throw new WSCException(WSCExceptionType.UNRECOGNIZED_RESPONSE.shortDesc);
        }
        MessageID messageId = ((HeaderIDWSF)envelope.getHeader()).getMessageID();
        if (null == messageId || null == messageId.getValue()) {
            throw new WSCException(WSCExceptionType.AUTHENTICATION_SERVICE_FAILURE.shortDesc + " No <MessageID> Element in SOAP Response Header");
        }
        if (isDebug) {
            log.debug((Object)("     SASL RESPONSE MessageID " + messageId.getValue()));
        }
        this.lastMessageId = messageId.getValue();
        this.lastResponseCode = ResponseCode.getResponseCode(response);
        return response;
    }

    public static enum ResponseCode {
        CONTINUE("continue"),
        ABORT("abort"),
        OK("ok");

        public String codeValue;

        private ResponseCode(String codeValue) {
            this.codeValue = codeValue;
        }

        public static ResponseCode getResponseCode(SASLResponse response) throws WSCException {
            Status status = response.getStatus();
            if (null != status) {
                return ResponseCode.getResponseCode(status.getCode());
            }
            throw new WSCException("Authentication Service Failure: No <Status> Element in SASL Response");
        }

        public static ResponseCode getResponseCode(String codeValue) throws WSCException {
            codeValue = codeValue.toLowerCase();
            for (ResponseCode responseCode : ResponseCode.values()) {
                if (!responseCode.codeValue.equals(codeValue)) continue;
                return responseCode;
            }
            throw new WSCException("Authentication Service Client Failure: unsupported status returned from AS '" + codeValue + "'");
        }
    }

    public static enum AuthMechanism {
        CRAM_MD5("CRAM-MD5"),
        PLAIN("PLAIN");

        public String code;

        private AuthMechanism(String code) {
            this.code = code;
        }

        public static AuthMechanism findAuthMechanism(String mechanism) throws WSCException {
            mechanism = mechanism.toUpperCase();
            for (AuthMechanism authMechanism : AuthMechanism.values()) {
                if (!authMechanism.code.equals(mechanism)) continue;
                return authMechanism;
            }
            throw new WSCException("Authentication Service Client Failure: unsupported authorization mechanism '" + mechanism + "'");
        }
    }

    public static enum WSCExceptionType {
        ILLEGAL_ARGUMENTS("ILLEGAL_ARGUMENTS: "),
        UNEXPECTED_SERVER_AUTH_MECHANISM("UNEXPECTED_SERVER_AUTH_MECHANISM: The server returned a serverMechanism in the SASLResponse that does not match the one requested"),
        CRAM_MD5_CHALLENGE_IS_EMPTY("CRAM_MD5_CHALLENGE_IS_EMPTY: The SASLResponse contained a <Data> element that should have contained a CRAM-MD5 Challenge, but did not"),
        NO_DATA_IN_SASL_RESPONSE("NO_DATA_IN_SASL_RESPONSE: There is no <Data> element in the SASLResponse"),
        UNRECOGNIZED_RESPONSE("UNRECOGNIZED_RESPONSE: The Authentication Service response for a SASLRequest did not contain a SASLResponse"),
        UNEXPECTED_STATUS_CODE("UNEXPECTED_STATUS_CODE: "),
        AUTHENTICATION_SERVICE_INVOCATION_FAILURE("AUTHENTICATION_SERVICE_INVOCATION_FAILURE: Failed to invoke the service call as specified"),
        AUTHENTICATION_SERVICE_FAILURE("AUTHENTICATION_SERVICE_FAILURE: "),
        CONTINUE_NOT_SUPPORTED_IN_AUTHENTICATE_CONTEXT("CONTINUE_NOT_SUPPORTED_IN_AUTHENTICATE_CONTEXT: AuthenticationService Client Exception");

        String shortDesc;

        private WSCExceptionType(String shortDesc) {
            this.shortDesc = shortDesc;
        }
    }
}

