/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.wsc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.apache.commons.io.IOUtils;
import org.apache.commons.ssl.KeyMaterial;
import org.apache.commons.ssl.SSL;
import org.apache.commons.ssl.SSLClient;
import org.apache.commons.ssl.TrustChain;
import org.apache.commons.ssl.TrustMaterial;
import org.apache.log4j.Logger;
import org.openliberty.LibConstants;
import org.openliberty.LibUtils;
import org.openliberty.wsc.OpenLibertyBootstrap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SSLUtilities {
    private static final Logger log = Logger.getLogger(SSLUtilities.class);
    private static final String SSL_RSA_WITH_RC4_128_MD5 = "SSL_RSA_WITH_RC4_128_MD5";
    @Deprecated
    public static boolean useOldStyleSSL = false;
    @Deprecated
    public static X509TrustManager xtm = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    };
    @Deprecated
    public static HostnameVerifier hnv = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    public static X509Certificate loadX509Certificate(String pathToX509Certificate) {
        X509Certificate cert = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            File certFile = new File(pathToX509Certificate);
            if (certFile.exists()) {
                try {
                    cert = (X509Certificate)cf.generateCertificate(new FileInputStream(certFile));
                }
                catch (FileNotFoundException e) {
                    log.error((Object)("Failed to load certificate from file " + certFile.getPath()));
                    e.printStackTrace();
                }
            } else {
                cert = (X509Certificate)cf.generateCertificate(SSLUtilities.class.getResourceAsStream(pathToX509Certificate));
            }
        }
        catch (CertificateException e) {
            log.error((Object)("Failed to load certificate: " + pathToX509Certificate));
            e.printStackTrace();
        }
        if (null != cert) {
            OpenLibertyBootstrap.getTrustedCertificates().add(cert);
        }
        return cert;
    }

    public static String postSOAPMessageNOTLS(String postUrlString, Element message) {
        String messageContent = SerializeSupport.nodeToString((Node)message);
        try {
            URL u = new URL(postUrlString);
            URLConnection uc = u.openConnection();
            HttpURLConnection connection = (HttpURLConnection)uc;
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("SOAPAction", "");
            OutputStream out = connection.getOutputStream();
            OutputStreamWriter wout = new OutputStreamWriter(out);
            wout.write(messageContent);
            ((Writer)wout).flush();
            ((Writer)wout).close();
            InputStream in = connection.getInputStream();
            String response = IOUtils.toString((InputStream)in);
            return response;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String postSOAPMessage(String postUrlString, Element message, boolean isClientTLS) throws GeneralSecurityException, IOException {
        boolean isDebugEnabled = log.isDebugEnabled();
        if (useOldStyleSSL) {
            SSLUtilities.initializeSSLProtocol();
            return SSLUtilities.postSOAPMessageViaHttpURLConnection(postUrlString, message);
        }
        SSLClient client = new SSLClient();
        for (Object cypher : SSL.SUPPORTED_CIPHERS_SET) {
            String[] strings;
            if (!SSL_RSA_WITH_RC4_128_MD5.equals(cypher)) continue;
            String[] enabledCyphers = client.getEnabledCiphers();
            String[] newlyEnabledCyphers = new String[enabledCyphers.length + 1];
            for (int i = 0; i < enabledCyphers.length; ++i) {
                newlyEnabledCyphers[i] = enabledCyphers[i];
            }
            newlyEnabledCyphers[newlyEnabledCyphers.length - 1] = SSL_RSA_WITH_RC4_128_MD5;
            client.setEnabledCiphers(newlyEnabledCyphers);
            if (!isDebugEnabled) break;
            log.debug((Object)"Cyphers Enabled:");
            for (String string : strings = client.getEnabledCiphers()) {
                log.debug((Object)("  > " + string));
            }
        }
        client.addTrustMaterial((TrustChain)TrustMaterial.DEFAULT);
        for (X509Certificate certificate : OpenLibertyBootstrap.getTrustedCertificates()) {
            client.addTrustMaterial((TrustChain)new TrustMaterial(certificate));
        }
        client.setCheckHostname(OpenLibertyBootstrap.isCheckHostName());
        client.setCheckExpiry(OpenLibertyBootstrap.isCheckExpiry());
        if (isClientTLS) {
            client.setKeyMaterial(new KeyMaterial(OpenLibertyBootstrap.getDefaultClientTLSPKSPath(), OpenLibertyBootstrap.getDefaultClientTLSPKSPassword().toCharArray()));
        }
        URL postUrl = new URL(postUrlString);
        if (isDebugEnabled) {
            log.debug((Object)("ClientTLS: " + isClientTLS + " host: " + postUrl.getHost() + " port: " + postUrl.getPort() + " query: " + postUrl.getPath()));
        }
        int port = postUrl.getPort();
        SSLSocket s = (SSLSocket)client.createSocket(postUrl.getHost(), port);
        if (isDebugEnabled) {
            log.debug((Object)"Socket created");
        }
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(s.getOutputStream())));
        String messageContent = SerializeSupport.nodeToString((Node)message);
        if (LibConstants.USE_AXIS_1_3_GREGORIAN_CALENDAR_SERIALIZATION_BUG_WORKAROUND) {
            messageContent = LibUtils.fixAxisGCSBug(messageContent);
        }
        out.println("POST " + postUrl.getPath() + " HTTP/1.1");
        out.println("Host: " + postUrl.getHost());
        out.println("Content-Type: text/soap+xml; charset=utf-8");
        out.println("Content-Length: " + messageContent.length());
        out.println("Connection: close");
        out.println("SOAPAction: \"\"\n");
        out.println(messageContent);
        out.println();
        out.flush();
        if (isDebugEnabled) {
            log.debug((Object)"SOAP Message Sent");
        }
        InputStream is = s.getInputStream();
        if (isDebugEnabled) {
            log.debug((Object)"input stream created");
        }
        if (null != is) {
            int first_lt;
            String response = IOUtils.toString((InputStream)is);
            if (LibConstants.USE_AXIS_1_3_GREGORIAN_CALENDAR_SERIALIZATION_BUG_WORKAROUND) {
                response = LibUtils.fixAxisGCSBug(response);
            }
            s.close();
            IOUtils.closeQuietly((InputStream)is);
            if (isDebugEnabled) {
                log.debug((Object)"input stream closed");
            }
            if ((first_lt = response.indexOf("<")) != -1) {
                int last_gt = response.lastIndexOf(62);
                response = last_gt < response.length() - 1 ? response.substring(first_lt, last_gt + 1) : response.substring(first_lt);
            } else {
                log.error((Object)"BAD RESPONSE FROM SERVER, EXPECTED SOAP");
                log.error((Object)response);
                response = "";
            }
            if (isDebugEnabled) {
                log.debug((Object)"RESPONSE:");
                log.debug((Object)response);
            }
            return response;
        }
        s.close();
        return "";
    }

    @Deprecated
    public static void initializeSSLProtocol() {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            TrustManager[] xtmArray = new X509TrustManager[]{xtm};
            sslContext.init(null, xtmArray, new SecureRandom());
        }
        catch (GeneralSecurityException gse) {
            gse.printStackTrace();
        }
        if (sslContext != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        }
        HttpsURLConnection.setDefaultHostnameVerifier(hnv);
    }

    @Deprecated
    public static String postSOAPMessageViaHttpURLConnection(String urlString, Element message) throws IOException {
        HttpURLConnection conn = null;
        conn = SSLUtilities.createConnection(urlString);
        OutputStream os = conn.getOutputStream();
        IOUtils.write((String)SerializeSupport.nodeToString((Node)message), (OutputStream)os);
        os.flush();
        IOUtils.closeQuietly((OutputStream)os);
        InputStream is = conn.getResponseCode() == 200 ? conn.getInputStream() : conn.getErrorStream();
        if (null != is) {
            String response = IOUtils.toString((InputStream)is);
            IOUtils.closeQuietly((InputStream)is);
            return response;
        }
        return "";
    }

    @Deprecated
    public static String postSOAPFileViaHttpURLConnection(String urlString, String inputFileName) throws IOException {
        HttpURLConnection conn = null;
        conn = SSLUtilities.createConnection(urlString);
        InputStream is = SSLUtilities.class.getResourceAsStream(inputFileName);
        String fileContents = IOUtils.toString((InputStream)is);
        IOUtils.closeQuietly((InputStream)is);
        OutputStream os = conn.getOutputStream();
        IOUtils.write((String)fileContents, (OutputStream)os);
        os.flush();
        IOUtils.closeQuietly((OutputStream)os);
        is = conn.getInputStream();
        String response = IOUtils.toString((InputStream)is);
        IOUtils.closeQuietly((InputStream)is);
        return response;
    }

    @Deprecated
    public static String postSOAPMessageViaHttpURLConnection(String urlString, String message) throws IOException {
        HttpURLConnection conn = null;
        conn = SSLUtilities.createConnection(urlString);
        OutputStream os = conn.getOutputStream();
        IOUtils.write((String)message, (OutputStream)os);
        os.flush();
        IOUtils.closeQuietly((OutputStream)os);
        InputStream is = conn.getInputStream();
        String response = IOUtils.toString((InputStream)is);
        IOUtils.closeQuietly((InputStream)is);
        return response;
    }

    @Deprecated
    public static InputStream postSOAPMessageViaHttpURLConnectionIS(String urlString, String message) throws IOException {
        HttpURLConnection conn = null;
        conn = SSLUtilities.createConnection(urlString);
        OutputStream os = conn.getOutputStream();
        IOUtils.write((String)message, (OutputStream)os);
        os.flush();
        IOUtils.closeQuietly((OutputStream)os);
        InputStream is = conn.getInputStream();
        return is;
    }

    @Deprecated
    private static HttpURLConnection createConnection(String urlString) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(urlString).openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("SOAPAction", "");
        conn.setInstanceFollowRedirects(false);
        conn.setUseCaches(false);
        return conn;
    }
}

