/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.wsc;

import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.openliberty.wsc.OpenLibertyBootstrap;
import org.openliberty.wsc.WSFMessage;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.soap.soap11.Envelope;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSFMessageSigner {
    public Element sign(WSFMessage message) throws Exception {
        String providerName = System.getProperty("jsr105Provider", "org.jcp.xml.dsig.internal.dom.XMLDSigRI");
        XMLSignatureFactory xmlSignatureFactory = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).newInstance());
        DigestMethod digestMethod = xmlSignatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
        Vector<Transform> transforms = new Vector<Transform>(2);
        transforms.add(xmlSignatureFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
        Vector<String> prefixlist = new Vector<String>(1);
        prefixlist.add("xsd");
        transforms.add(xmlSignatureFactory.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", new ExcC14NParameterSpec(prefixlist)));
        ArrayList<Reference> references = new ArrayList<Reference>();
        for (String id : message.getSignatureIds()) {
            Reference ref = xmlSignatureFactory.newReference("#" + id, digestMethod, transforms, null, null);
            references.add(ref);
        }
        CanonicalizationMethod canonicalizationMethod = xmlSignatureFactory.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null);
        SignatureMethod signatureMethod = xmlSignatureFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
        SignedInfo signedInfo = xmlSignatureFactory.newSignedInfo(canonicalizationMethod, signatureMethod, references);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(WSFMessageSigner.class.getResourceAsStream(OpenLibertyBootstrap.getDefaultSigningPKSPath()), OpenLibertyBootstrap.getDefaultSigningPKSPassword().toCharArray());
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(OpenLibertyBootstrap.getDefaultSigningPKSAlias(), OpenLibertyBootstrap.getDefaultSigningPKSPassword().toCharArray());
        Certificate c = keyStore.getCertificate(OpenLibertyBootstrap.getDefaultSigningPKSAlias());
        PublicKey p = c.getPublicKey();
        KeyInfoFactory keyInfoFactory = xmlSignatureFactory.getKeyInfoFactory();
        KeyValue kv = keyInfoFactory.newKeyValue(p);
        KeyInfo ki = keyInfoFactory.newKeyInfo(Collections.singletonList(kv));
        XMLSignature signature = xmlSignatureFactory.newXMLSignature(signedInfo, ki);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document doc = null;
        Element securityHeader = null;
        Element timestamp = null;
        try {
            Envelope envelope = message.getRequestEnvelope();
            Marshaller envelopeMarshaller = XMLObjectSupport.getMarshaller((QName)Envelope.DEFAULT_ELEMENT_NAME);
            Element envelopeElement = envelopeMarshaller.marshall((XMLObject)envelope);
            Document messageDoc = envelopeElement.getOwnerDocument();
            String docAsString = SerializeSupport.nodeToString((Node)messageDoc.getFirstChild());
            doc = documentBuilder.parse(new ByteArrayInputStream(docAsString.getBytes()));
            NodeList nodeList = doc.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
            securityHeader = (Element)nodeList.item(0);
            nodeList = securityHeader.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp");
            timestamp = (Element)nodeList.item(0);
        }
        catch (MarshallingException e) {
            e.printStackTrace();
        }
        DOMSignContext signContext = new DOMSignContext(privateKey, securityHeader, timestamp);
        signContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
        signContext.putNamespacePrefix("http://www.w3.org/2001/10/xml-exc-c14n#", "ec");
        signature.sign(signContext);
        return doc.getDocumentElement();
    }
}

