/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.xmltooling.idsis.dap;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;
import org.openliberty.xmltooling.dst2_1.RequestType;
import org.openliberty.xmltooling.idsis.dap.DAPCreateItem;
import org.openliberty.xmltooling.idsis.dap.DAPNewData;
import org.openliberty.xmltooling.idsis.dap.DAPResultQuery;
import org.openliberty.xmltooling.idsis.dap.DAPSubscription;
import org.openliberty.xmltooling.idsis.dap.LDIF;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.opensaml.core.xml.AbstractXMLObject;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DAPCreate
extends RequestType {
    public static String LOCAL_NAME = "Create";
    private XMLObjectChildrenList<DAPSubscription> subscriptions;
    private XMLObjectChildrenList<DAPCreateItem> createItems;
    private XMLObjectChildrenList<DAPResultQuery> resultQueries;

    public DAPCreate(DAPCreateItem createItem) {
        super("urn:liberty:id-sis-dap:2006-02:dst-2.1", LOCAL_NAME, "dap");
        this.createItems = new XMLObjectChildrenList((XMLObject)this);
        this.createItems.add((Object)createItem);
    }

    public DAPCreate(String ldifCreateString, String itemId) {
        super("urn:liberty:id-sis-dap:2006-02:dst-2.1", LOCAL_NAME, "dap");
        if (null == itemId) {
            itemId = UUID.randomUUID().toString();
        }
        this.setItemID(itemId);
        DAPCreateItem createItem = new DAPCreateItem();
        createItem.getCreateItemAttributeGroup().setItemID(UUID.randomUUID().toString(), (AbstractXMLObject)createItem);
        LDIF ldif = new LDIF();
        ldif.setValue(ldifCreateString);
        DAPNewData newData = new DAPNewData();
        newData.setLDIF(ldif);
        createItem.setNewData(newData);
        this.createItems = new XMLObjectChildrenList((XMLObject)this);
        this.createItems.add((Object)createItem);
    }

    protected DAPCreate(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
        this.createItems = new XMLObjectChildrenList((XMLObject)this);
    }

    public XMLObjectChildrenList<DAPSubscription> getDAPSubscriptions() {
        if (null == this.subscriptions) {
            this.subscriptions = new XMLObjectChildrenList((XMLObject)this);
        }
        return this.subscriptions;
    }

    public XMLObjectChildrenList<DAPCreateItem> getDAPCreateItems() {
        return this.createItems;
    }

    public XMLObjectChildrenList<DAPResultQuery> getDAPResultQueries() {
        if (null == this.resultQueries) {
            this.resultQueries = new XMLObjectChildrenList((XMLObject)this);
        }
        return this.resultQueries;
    }

    @Override
    public List<XMLObject> getOrderedChildren() {
        LinkedList<Object> children = new LinkedList<Object>();
        children.addAll(super.getOrderedChildren());
        if (null != this.subscriptions) {
            children.addAll((Collection<Object>)this.subscriptions);
        }
        if (null != this.createItems) {
            children.addAll((Collection<Object>)this.createItems);
        }
        if (null != this.resultQueries) {
            children.addAll((Collection<Object>)this.resultQueries);
        }
        return Collections.unmodifiableList(children);
    }

    public static class Builder
    extends AbstractXMLObjectBuilder<DAPCreate> {
        public DAPCreate buildObject(String namespaceURI, String localName, String namespacePrefix) {
            return new DAPCreate(namespaceURI, localName, namespacePrefix);
        }
    }

    public static class Unmarshaller
    extends AbstractXMLObjectUnmarshaller {
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException {
            DAPCreate obj = (DAPCreate)parentXMLObject;
            if (childXMLObject instanceof DAPResultQuery) {
                obj.getDAPResultQueries().add((Object)((DAPResultQuery)childXMLObject));
            } else if (childXMLObject instanceof DAPCreateItem) {
                obj.getDAPCreateItems().add((Object)((DAPCreateItem)childXMLObject));
            } else if (childXMLObject instanceof DAPSubscription) {
                obj.getDAPSubscriptions().add((Object)((DAPSubscription)childXMLObject));
            } else if (childXMLObject instanceof Extension) {
                obj.getExtensions().add((Object)((Extension)childXMLObject));
            }
        }

        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
            DAPCreate obj = (DAPCreate)xmlObject;
            if (attribute.getLocalName().equals("itemID")) {
                obj.setItemID(attribute.getValue());
            } else {
                QName attribQName = QNameSupport.getNodeQName((Node)attribute);
                if (attribute.isId()) {
                    obj.getUnknownAttributes().registerID(attribQName);
                }
                obj.getUnknownAttributes().put(attribQName, attribute.getValue());
            }
        }

        protected void processElementContent(XMLObject xmlObject, String elementContent) {
        }
    }

    public static class Marshaller
    extends AbstractXMLObjectMarshaller {
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException {
            DAPCreate obj = (DAPCreate)xmlObject;
            if (obj.getItemID() != null) {
                domElement.setAttributeNS(null, "itemID", obj.getItemID());
            }
            for (Map.Entry entry : obj.getUnknownAttributes().entrySet()) {
                Attr attr = AttributeSupport.constructAttribute((Document)domElement.getOwnerDocument(), (QName)((QName)entry.getKey()));
                attr.setValue((String)entry.getValue());
                domElement.setAttributeNodeNS(attr);
                if (!XMLObjectProviderRegistrySupport.isIDAttribute((QName)((QName)entry.getKey())) && !obj.getUnknownAttributes().isIDAttribute((QName)entry.getKey())) continue;
                attr.getOwnerElement().setIdAttributeNode(attr, true);
            }
        }

        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException {
        }
    }
}

