/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.xmltooling.idsis.dap;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.joda.time.DateTime;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.openliberty.xmltooling.dst2_1.RequestType;
import org.openliberty.xmltooling.idsis.dap.DAPNotification;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class DAPNotify
extends RequestType {
    public static String LOCAL_NAME = "Notify";
    private DateTime timeStamp;
    public static String ATT_TIME_STAMP = "timeStamp";
    private XMLObjectChildrenList<DAPNotification> notifications;

    protected DAPNotify(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public DateTime getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(DateTime timeStamp) {
        this.timeStamp = (DateTime)this.prepareForAssignment(this.timeStamp, timeStamp);
    }

    public XMLObjectChildrenList<DAPNotification> getDAPNotifications() {
        if (null == this.notifications) {
            this.notifications = new XMLObjectChildrenList((XMLObject)this);
        }
        return this.notifications;
    }

    @Override
    public List<XMLObject> getOrderedChildren() {
        LinkedList<Object> children = new LinkedList<Object>();
        children.addAll(super.getOrderedChildren());
        if (null != this.notifications) {
            children.addAll((Collection<Object>)this.notifications);
        }
        return Collections.unmodifiableList(children);
    }

    public static class Builder
    extends AbstractXMLObjectBuilder<DAPNotify> {
        public DAPNotify buildObject(String namespaceURI, String localName, String namespacePrefix) {
            return new DAPNotify(namespaceURI, localName, namespacePrefix);
        }
    }

    public static class Unmarshaller
    extends RequestType.Unmarshaller {
        @Override
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
            DAPNotify obj = (DAPNotify)xmlObject;
            if (attribute.getLocalName().equals(ATT_TIME_STAMP)) {
                obj.setTimeStamp(OpenLibertyHelpers.dateTimeForString(attribute.getValue()));
            } else {
                super.processAttribute(xmlObject, attribute);
            }
        }

        @Override
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException {
            DAPNotify obj = (DAPNotify)parentXMLObject;
            if (childXMLObject instanceof DAPNotification) {
                obj.getDAPNotifications().add((Object)((DAPNotification)childXMLObject));
            } else {
                super.processChildElement(parentXMLObject, childXMLObject);
            }
        }
    }

    public static class Marshaller
    extends RequestType.Marshaller {
        @Override
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException {
            DAPNotify obj = (DAPNotify)xmlObject;
            if (obj.getTimeStamp() != null) {
                domElement.setAttributeNS(null, ATT_TIME_STAMP, OpenLibertyHelpers.stringForDateTime(obj.getTimeStamp()));
            }
            super.marshallAttributes(xmlObject, domElement);
        }
    }
}

