/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.xmltooling.idsis.dap;

import java.util.Map;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.openliberty.xmltooling.dst2_1.DataResponseBaseType;
import org.openliberty.xmltooling.dst2_1.TestResult;
import org.openliberty.xmltooling.idsis.dap.DAPData;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.openliberty.xmltooling.utility_2_0.Status;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DAPQueryResponse
extends DataResponseBaseType {
    private XMLObjectChildrenList<TestResult> testResults;
    private XMLObjectChildrenList<DAPData> dataList;

    public DAPQueryResponse(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public XMLObjectChildrenList<DAPData> getDAPDatas() {
        if (null == this.dataList) {
            this.dataList = new XMLObjectChildrenList((XMLObject)this);
        }
        return this.dataList;
    }

    public XMLObjectChildrenList<TestResult> getTestResults() {
        if (null == this.testResults) {
            this.testResults = new XMLObjectChildrenList((XMLObject)this);
        }
        return this.testResults;
    }

    public static class Builder
    extends AbstractXMLObjectBuilder<DAPQueryResponse> {
        public DAPQueryResponse buildObject(String namespaceURI, String localName, String namespacePrefix) {
            return new DAPQueryResponse(namespaceURI, localName, namespacePrefix);
        }
    }

    public static class Unmarshaller
    extends AbstractXMLObjectUnmarshaller {
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException {
            DAPQueryResponse obj = (DAPQueryResponse)parentXMLObject;
            if (childXMLObject instanceof Status) {
                obj.setStatus((Status)childXMLObject);
            } else if (childXMLObject instanceof DAPData) {
                obj.getDAPDatas().add((Object)((DAPData)childXMLObject));
            } else if (childXMLObject instanceof TestResult) {
                obj.getTestResults().add((Object)((TestResult)childXMLObject));
            } else if (childXMLObject instanceof Extension) {
                obj.getExtensions().add((Object)((Extension)childXMLObject));
            }
        }

        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
            DAPQueryResponse obj = (DAPQueryResponse)xmlObject;
            if (attribute.getLocalName().equals("timeStamp")) {
                obj.setTimeStamp(OpenLibertyHelpers.dateTimeForString(attribute.getValue()));
            } else if (attribute.getLocalName().equals("itemIDRef")) {
                obj.setItemRefId(attribute.getValue());
            } else {
                QName attribQName = QNameSupport.getNodeQName((Node)attribute);
                if (attribute.isId()) {
                    obj.getUnknownAttributes().registerID(attribQName);
                }
                obj.getUnknownAttributes().put(attribQName, attribute.getValue());
            }
        }

        protected void processElementContent(XMLObject xmlObject, String elementContent) {
        }
    }

    public static class Marshaller
    extends AbstractXMLObjectMarshaller {
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException {
            DAPQueryResponse obj = (DAPQueryResponse)xmlObject;
            if (obj.getTimeStamp() != null) {
                domElement.setAttributeNS(null, "timeStamp", OpenLibertyHelpers.stringForDateTime(obj.getTimeStamp()));
            }
            if (obj.getItemRefId() != null) {
                domElement.setAttributeNS(null, "itemIDRef", obj.getItemRefId());
            }
            for (Map.Entry entry : obj.getUnknownAttributes().entrySet()) {
                Attr attr = AttributeSupport.constructAttribute((Document)domElement.getOwnerDocument(), (QName)((QName)entry.getKey()));
                attr.setValue((String)entry.getValue());
                domElement.setAttributeNodeNS(attr);
                if (!XMLObjectProviderRegistrySupport.isIDAttribute((QName)((QName)entry.getKey())) && !obj.getUnknownAttributes().isIDAttribute((QName)entry.getKey())) continue;
                attr.getOwnerElement().setIdAttributeNode(attr, true);
            }
        }

        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException {
        }
    }
}

