/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.xmltooling.idsis.dap;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.openliberty.xmltooling.idsis.dap.DN;
import org.openliberty.xmltooling.idsis.dap.Filter;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.impl.XSStringImpl;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class DAPSelect
extends AbstractSignableXMLObject {
    public static String LOCAL_NAME = "Select";
    private DN dn;
    private Filter filter;
    private Integer sizelimit;
    private Integer timelimit;
    private Boolean typesonly;
    private Integer scope;
    private Integer derefaliases;
    private String attributes;
    public static final String ATT_SCOPE = "scope";
    public static final String ATT_SIZELIMIT = "sizelimit";
    public static final String ATT_TIMELIMIT = "timelimit";
    public static final String ATT_ATTRIBUTES = "attributes";
    public static final String ATT_TYPESONLY = "typesonly";
    public static final String ATT_DEREFALIASES = "derefaliases";

    public DAPSelect() {
        super("urn:liberty:id-sis-dap:2006-02:dst-2.1", LOCAL_NAME, "dap");
    }

    public DAPSelect(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public void setTypesonly(Boolean typesonly) {
        this.typesonly = (Boolean)this.prepareForAssignment(this.typesonly, typesonly);
    }

    public Boolean getTypesonly() {
        return this.typesonly;
    }

    public void setSizelimit(Integer sizelimit) {
        this.sizelimit = (Integer)this.prepareForAssignment(this.sizelimit, sizelimit);
    }

    public Integer getSizeLimit() {
        return this.sizelimit;
    }

    public void setTimelimit(Integer timelimit) {
        this.timelimit = (Integer)this.prepareForAssignment(this.timelimit, timelimit);
    }

    public Integer getTimelimit() {
        return this.timelimit;
    }

    public void setAttributes(String attributes) {
        this.attributes = this.prepareForAssignment(this.attributes, attributes);
    }

    public String getAttributes() {
        return this.attributes;
    }

    public void setScope(Integer scope) {
        this.scope = (Integer)this.prepareForAssignment(this.scope, scope);
    }

    public Integer getScope() {
        return this.scope;
    }

    public void setDerefaliases(Integer derefaliases) {
        this.derefaliases = (Integer)this.prepareForAssignment(this.derefaliases, derefaliases);
    }

    public Integer getDerefaliases() {
        return this.derefaliases;
    }

    public DN getDn() {
        return this.dn;
    }

    public void setDn(DN dn) {
        this.dn = (DN)this.prepareForAssignment((XMLObject)this.dn, (XMLObject)dn);
    }

    public void setDn(String dnString) {
        DN dn = new DN();
        dn.setValue(dnString);
        this.dn = (DN)this.prepareForAssignment((XMLObject)this.dn, (XMLObject)dn);
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = (Filter)this.prepareForAssignment((XMLObject)this.filter, (XMLObject)filter);
    }

    public void setFilter(String filterString) {
        Filter filter = new Filter();
        filter.setValue(filterString);
        this.filter = (Filter)this.prepareForAssignment((XMLObject)this.filter, (XMLObject)filter);
    }

    public List<XMLObject> getOrderedChildren() {
        LinkedList<XSStringImpl> children = new LinkedList<XSStringImpl>();
        if (null != this.filter) {
            children.add(this.filter);
        }
        if (null != this.dn) {
            children.add(this.dn);
        }
        return Collections.unmodifiableList(children);
    }

    public static class Unmarshaller
    extends AbstractXMLObjectUnmarshaller {
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
            DAPSelect obj = (DAPSelect)xmlObject;
            String attLocalName = attribute.getLocalName();
            if (attLocalName.equals(DAPSelect.ATT_SCOPE)) {
                obj.setScope(OpenLibertyHelpers.integerFromString(attribute.getValue()));
            } else if (attLocalName.equals(DAPSelect.ATT_SIZELIMIT)) {
                obj.setSizelimit(OpenLibertyHelpers.integerFromString(attribute.getValue()));
            } else if (attLocalName.equals(DAPSelect.ATT_TIMELIMIT)) {
                obj.setTimelimit(OpenLibertyHelpers.integerFromString(attribute.getValue()));
            } else if (attLocalName.equals(DAPSelect.ATT_ATTRIBUTES)) {
                obj.setAttributes(attribute.getValue());
            } else if (attLocalName.equals(DAPSelect.ATT_TYPESONLY)) {
                obj.setTypesonly(OpenLibertyHelpers.booleanFromString(attribute.getValue()));
            } else if (attLocalName.equals(DAPSelect.ATT_DEREFALIASES)) {
                obj.setDerefaliases(OpenLibertyHelpers.integerFromString(attribute.getValue()));
            }
        }

        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException {
            DAPSelect obj = (DAPSelect)parentXMLObject;
            if (childXMLObject instanceof DN) {
                obj.setDn((DN)childXMLObject);
            } else if (childXMLObject instanceof Filter) {
                obj.setFilter((Filter)childXMLObject);
            }
        }

        protected void processElementContent(XMLObject xmlObject, String elementContent) {
        }
    }

    public static class Marshaller
    extends AbstractXMLObjectMarshaller {
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException {
            DAPSelect obj = (DAPSelect)xmlObject;
            if (obj.getScope() != null) {
                domElement.setAttributeNS(null, DAPSelect.ATT_SCOPE, obj.getScope().toString());
            }
            if (obj.getSizeLimit() != null) {
                domElement.setAttributeNS(null, DAPSelect.ATT_SIZELIMIT, obj.getSizeLimit().toString());
            }
            if (obj.getTimelimit() != null) {
                domElement.setAttributeNS(null, DAPSelect.ATT_TIMELIMIT, obj.getTimelimit().toString());
            }
            if (obj.getAttributes() != null) {
                domElement.setAttributeNS(null, DAPSelect.ATT_ATTRIBUTES, obj.getAttributes());
            }
            if (obj.getTypesonly() != null) {
                domElement.setAttributeNS(null, DAPSelect.ATT_TYPESONLY, OpenLibertyHelpers.stringFromBoolean(obj.getTypesonly(), OpenLibertyHelpers.FALSE_STR));
            }
            if (obj.getDerefaliases() != null) {
                domElement.setAttributeNS(null, DAPSelect.ATT_DEREFALIASES, obj.getDerefaliases().toString());
            }
        }

        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException {
        }
    }

    public static class Builder
    extends AbstractXMLObjectBuilder<DAPSelect> {
        public DAPSelect buildObject() {
            return new DAPSelect();
        }

        public DAPSelect buildObject(String namespaceURI, String localName, String namespacePrefix) {
            return new DAPSelect(namespaceURI, localName, namespacePrefix);
        }
    }
}

