/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.xmltooling.idsis.dap;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.openliberty.xmltooling.dst2_1.DataResponseBaseType;
import org.openliberty.xmltooling.idsis.dap.DAPItemData;
import org.openliberty.xmltooling.utility_2_0.Extension;
import org.openliberty.xmltooling.utility_2_0.Status;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class DataResponseType
extends DataResponseBaseType {
    private XMLObjectChildrenList<DAPItemData> itemDataList;

    protected DataResponseType(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public XMLObjectChildrenList<DAPItemData> getItemDataList() {
        if (null == this.itemDataList) {
            this.itemDataList = new XMLObjectChildrenList((XMLObject)this);
        }
        return this.itemDataList;
    }

    @Override
    public List<XMLObject> getOrderedChildren() {
        LinkedList<Object> children = new LinkedList<Object>();
        children.addAll(super.getOrderedChildren());
        if (null != this.itemDataList) {
            children.addAll((Collection<Object>)this.itemDataList);
        }
        return Collections.unmodifiableList(children);
    }

    public static class Marshaller
    extends AbstractXMLObjectMarshaller {
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException {
            DataResponseType obj = (DataResponseType)xmlObject;
            if (obj.getTimeStamp() != null) {
                domElement.setAttributeNS(null, "timeStamp", OpenLibertyHelpers.stringForDateTime(obj.getTimeStamp()));
            }
            if (obj.getItemRefId() != null) {
                domElement.setAttributeNS(null, "itemIDRef", obj.getItemRefId());
            }
            for (Map.Entry entry : obj.getUnknownAttributes().entrySet()) {
                Attr attr = AttributeSupport.constructAttribute((Document)domElement.getOwnerDocument(), (QName)((QName)entry.getKey()));
                attr.setValue((String)entry.getValue());
                domElement.setAttributeNodeNS(attr);
                if (!XMLObjectProviderRegistrySupport.isIDAttribute((QName)((QName)entry.getKey())) && !obj.getUnknownAttributes().isIDAttribute((QName)entry.getKey())) continue;
                attr.getOwnerElement().setIdAttributeNode(attr, true);
            }
        }

        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException {
        }
    }

    public static class Unmarshaller
    extends AbstractXMLObjectUnmarshaller {
        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
            DataResponseType obj = (DataResponseType)xmlObject;
            if (attribute.getLocalName().equals("timeStamp")) {
                obj.setTimeStamp(OpenLibertyHelpers.dateTimeForString(attribute.getValue()));
            } else if (attribute.getLocalName().equals("itemIDRef")) {
                obj.setItemRefId(attribute.getValue());
            } else {
                QName attribQName = QNameSupport.getNodeQName((Node)attribute);
                if (attribute.isId()) {
                    obj.getUnknownAttributes().registerID(attribQName);
                }
                obj.getUnknownAttributes().put(attribQName, attribute.getValue());
            }
        }

        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException {
            DataResponseType obj = (DataResponseType)parentXMLObject;
            if (childXMLObject instanceof DAPItemData) {
                obj.getItemDataList().add((Object)((DAPItemData)childXMLObject));
            } else if (childXMLObject instanceof Status) {
                obj.setStatus((Status)childXMLObject);
            } else if (childXMLObject instanceof Extension) {
                obj.getExtensions().add((Object)((Extension)childXMLObject));
            }
        }

        protected void processElementContent(XMLObject xmlObject, String elementContent) {
        }
    }
}

