/*
 * Decompiled with CFR 0.152.
 */
package org.openliberty.xmltooling.soapbinding;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.AttributeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;
import org.openliberty.xmltooling.OpenLibertyHelpers;
import org.openliberty.xmltooling.soapbinding.InteractionService;
import org.opensaml.core.xml.AbstractXMLObjectBuilder;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.AbstractXMLObjectMarshaller;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.core.xml.util.XMLObjectChildrenList;
import org.opensaml.xmlsec.signature.AbstractSignableXMLObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UserInteraction
extends AbstractSignableXMLObject
implements AttributeExtensibleXMLObject {
    public static final String LOCAL_NAME = "UserInteraction";
    private XMLObjectChildrenList<InteractionService> interactionServices;
    private String interact;
    private String language;
    private Boolean redirect;
    private Integer maxInteractTime;
    private AttributeMap unknownAttributes;
    public static final String ATT_INTERACT = "interact";
    public static final String ATT_LANGUAGE = "language";
    public static final String ATT_REDIRECT = "redirect";
    public static final String ATT_MAX_INTERACT_TIME = "maxInteractTime";

    public UserInteraction() {
        super("urn:liberty:sb:2006-08", LOCAL_NAME, "sb");
    }

    public UserInteraction(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    public String getInteract() {
        return this.interact;
    }

    public void setInteract(String interact) {
        this.interact = this.prepareForAssignment(this.interact, interact);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = this.prepareForAssignment(this.language, language);
    }

    public Boolean getRedirect() {
        return this.redirect;
    }

    public void setRedirect(Boolean redirect) {
        this.redirect = (Boolean)this.prepareForAssignment(this.redirect, redirect);
    }

    public Integer getMaxInteractTime() {
        return this.maxInteractTime;
    }

    public void setMaxInteractTime(Integer maxInteractTime) {
        this.maxInteractTime = (Integer)this.prepareForAssignment(this.maxInteractTime, maxInteractTime);
    }

    public XMLObjectChildrenList<InteractionService> getInteractionServices() {
        if (null == this.interactionServices) {
            this.interactionServices = new XMLObjectChildrenList((XMLObject)this);
        }
        return this.interactionServices;
    }

    public List<XMLObject> getOrderedChildren() {
        LinkedList<InteractionService> children = new LinkedList<InteractionService>();
        if (null != this.interactionServices) {
            children.addAll((Collection<InteractionService>)this.interactionServices);
        }
        return Collections.unmodifiableList(children);
    }

    public AttributeMap getUnknownAttributes() {
        if (null == this.unknownAttributes) {
            this.unknownAttributes = new AttributeMap((XMLObject)this);
        }
        return this.unknownAttributes;
    }

    public static class Builder
    extends AbstractXMLObjectBuilder<UserInteraction> {
        public UserInteraction buildObject(String namespaceURI, String localName, String namespacePrefix) {
            return new UserInteraction(namespaceURI, localName, namespacePrefix);
        }
    }

    public static class Unmarshaller
    extends AbstractXMLObjectUnmarshaller {
        protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException {
            UserInteraction obj = (UserInteraction)parentXMLObject;
            if (childXMLObject instanceof InteractionService) {
                obj.getInteractionServices().add((Object)((InteractionService)childXMLObject));
            }
        }

        protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
            UserInteraction obj = (UserInteraction)xmlObject;
            String attLocalName = attribute.getLocalName();
            if (attLocalName.equals(UserInteraction.ATT_INTERACT)) {
                obj.setInteract(attribute.getValue());
            } else if (attLocalName.equals(UserInteraction.ATT_LANGUAGE)) {
                obj.setLanguage(attribute.getValue());
            } else if (attLocalName.equals(UserInteraction.ATT_MAX_INTERACT_TIME)) {
                obj.setMaxInteractTime(OpenLibertyHelpers.integerFromString(attribute.getValue()));
            } else if (attLocalName.equals(UserInteraction.ATT_REDIRECT)) {
                obj.setRedirect(OpenLibertyHelpers.booleanFromString(attribute.getValue()));
            } else {
                QName attribQName = QNameSupport.getNodeQName((Node)attribute);
                if (attribute.isId()) {
                    obj.getUnknownAttributes().registerID(attribQName);
                }
                obj.getUnknownAttributes().put(attribQName, attribute.getValue());
            }
        }

        protected void processElementContent(XMLObject xmlObject, String elementContent) {
        }
    }

    public static class Marshaller
    extends AbstractXMLObjectMarshaller {
        protected void marshallAttributes(XMLObject xmlObject, Element domElement) throws MarshallingException {
            UserInteraction obj = (UserInteraction)xmlObject;
            if (obj.getInteract() != null) {
                domElement.setAttributeNS(null, UserInteraction.ATT_INTERACT, obj.getInteract());
            }
            if (obj.getLanguage() != null) {
                domElement.setAttributeNS(null, UserInteraction.ATT_LANGUAGE, obj.getLanguage());
            }
            if (obj.getMaxInteractTime() != null) {
                domElement.setAttributeNS(null, UserInteraction.ATT_MAX_INTERACT_TIME, obj.getMaxInteractTime().toString());
            }
            if (obj.getRedirect() != null) {
                domElement.setAttributeNS(null, UserInteraction.ATT_REDIRECT, OpenLibertyHelpers.stringFromBoolean(obj.getRedirect(), OpenLibertyHelpers.FALSE_STR));
            }
            for (Map.Entry entry : obj.getUnknownAttributes().entrySet()) {
                Attr attr = AttributeSupport.constructAttribute((Document)domElement.getOwnerDocument(), (QName)((QName)entry.getKey()));
                attr.setValue((String)entry.getValue());
                domElement.setAttributeNodeNS(attr);
                if (!XMLObjectProviderRegistrySupport.isIDAttribute((QName)((QName)entry.getKey())) && !obj.getUnknownAttributes().isIDAttribute((QName)entry.getKey())) continue;
                attr.getOwnerElement().setIdAttributeNode(attr, true);
            }
        }

        protected void marshallElementContent(XMLObject xmlObject, Element domElement) throws MarshallingException {
        }
    }

    public static enum Interact {
        INTERACT_IF_NEEDED("InteractIfNeeded"),
        DO_NOT_INTERACT("DoNotInteract"),
        DO_NOT_INTERACT_FOR_DATA("DoNotInteractForData");

        private String code;

        private Interact(String code) {
            this.code = code;
        }

        public Interact getInteractForCode(String code) {
            if (null != code) {
                for (Interact interact : Interact.values()) {
                    if (!interact.getCode().equals(code)) continue;
                    return interact;
                }
            }
            return null;
        }

        public String getCode() {
            return this.code;
        }
    }
}

