/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.httpclient.HttpClientContextHandler;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resource.Resource;
import net.shibboleth.shared.spring.httpclient.resource.FileBackedHTTPResource;
import net.shibboleth.shared.spring.httpclient.resource.HTTPResource;
import org.apache.hc.client5.http.classic.HttpClient;
import org.cryptacular.EncodingException;
import org.cryptacular.StreamException;
import org.cryptacular.util.KeyPairUtil;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.security.httpclient.HttpClientSecurityContextHandler;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.trust.impl.ExplicitKeyTrustEngine;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.security.x509.X509Support;
import org.opensaml.security.x509.impl.BasicPKIXValidationInformation;
import org.opensaml.security.x509.impl.PKIXX509CredentialTrustEngine;
import org.opensaml.security.x509.impl.StaticPKIXValidationInformationResolver;
import org.slf4j.Logger;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class HTTPResourceFactoryBean
extends AbstractFactoryBean<HTTPResource> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(FileBackedHTTPResource.class);
    @Nullable
    private String backingResource;
    @Nullable
    private HttpClient httpClient;
    @Nullable
    private URL resourceURL;
    @Nullable
    private HttpClientContextHandler httpClientContextHandler;
    @Nonnull
    private List<Resource> keyResources = CollectionSupport.emptyList();
    @Nonnull
    private List<Resource> certificateResources = CollectionSupport.emptyList();
    private boolean usePKIX;
    @Nullable
    private Integer verifyDepth;

    public void setURL(@Nullable URL url) {
        this.resourceURL = url;
    }

    public void setBackingResource(@Nullable @NotEmpty String resource) {
        this.backingResource = resource;
    }

    public void setHttpClient(@Nullable HttpClient client) {
        this.httpClient = client;
    }

    public void setHttpClientContextHandler(@Nullable HttpClientContextHandler handler) {
        this.httpClientContextHandler = handler;
    }

    public void setPublicKeys(@Nullable List<Resource> keys) {
        this.keyResources = keys != null ? keys : CollectionSupport.emptyList();
    }

    public void setCertificates(@Nullable List<Resource> certs) {
        this.certificateResources = certs != null ? certs : CollectionSupport.emptyList();
    }

    public void setUsePKIX(boolean flag) {
        this.usePKIX = flag;
    }

    public void setVerifyDepth(@Nullable Integer depth) {
        this.verifyDepth = depth;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected List<Credential> getCredentials() {
        InputStream is;
        ArrayList<BasicCredential> credentials = new ArrayList<BasicCredential>(this.keyResources.size() + this.certificateResources.size());
        for (Resource f : this.keyResources) {
            try {
                is = f.getInputStream();
                try {
                    credentials.add(new BasicCredential(KeyPairUtil.readPublicKey((InputStream)is)));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException | EncodingException | StreamException e) {
                this.log.error("Could not decode public key from {}: {}", (Object)f.getDescription(), (Object)e.getMessage());
                throw new FatalBeanException("Could not decode public key from " + f.getDescription(), e);
            }
        }
        for (Resource f : this.certificateResources) {
            try {
                is = f.getInputStream();
                try {
                    Collection raw = X509Support.decodeCertificates((InputStream)is);
                    if (raw == null) continue;
                    raw.forEach(x -> {
                        if (x != null) {
                            credentials.add((BasicCredential)new BasicX509Credential(x));
                        }
                    });
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException | CertificateException e) {
                this.log.error("Could not decode certificate from {}: {}", (Object)f.getDescription(), (Object)e.getMessage());
                throw new FatalBeanException("Could not decode certificate from " + f.getDescription(), (Throwable)e);
            }
        }
        return CollectionSupport.copyToList(credentials);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected List<X509Certificate> getCertificates() {
        ArrayList certificates = new ArrayList(this.certificateResources.size());
        for (Resource f : this.certificateResources) {
            try {
                InputStream is = f.getInputStream();
                try {
                    certificates.addAll(X509Support.decodeCertificates((InputStream)is));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException | CertificateException e) {
                this.log.error("Could not decode Certificate at {}: {}", (Object)f.getDescription(), (Object)e.getMessage());
                throw new FatalBeanException("Could not decode provided CertificateFile " + f.getDescription(), (Throwable)e);
            }
        }
        return CollectionSupport.copyToList(certificates);
    }

    public Class<?> getObjectType() {
        return HTTPResource.class;
    }

    @Nonnull
    protected HTTPResource createInstance() throws Exception {
        HttpClient httpClient2 = this.httpClient;
        URL resourceURL2 = this.resourceURL;
        if (httpClient2 == null || resourceURL2 == null) {
            throw new BeanCreationException("HttpClient and resource URL cannot be null");
        }
        Object theResource = this.backingResource != null ? new FileBackedHTTPResource(this.backingResource, httpClient2, resourceURL2) : new HTTPResource(httpClient2, resourceURL2);
        if (this.httpClientContextHandler != null) {
            theResource.setHttpClientContextHandler(this.httpClientContextHandler);
            if (!this.keyResources.isEmpty() || !this.certificateResources.isEmpty()) {
                this.log.warn("httpClientContextHandler set, ignoring supplied keys/certificates");
            }
        } else if (this.usePKIX) {
            if (!this.keyResources.isEmpty()) {
                this.log.warn("usePKIX set, ignoring supplied keys");
            }
            this.log.debug("Auto-wiring PKIXX509CredentialTrustEngine into HTTPResource");
            BasicPKIXValidationInformation info = new BasicPKIXValidationInformation(this.getCertificates(), null, this.verifyDepth);
            StaticPKIXValidationInformationResolver resolver = new StaticPKIXValidationInformationResolver(CollectionSupport.singletonList((Object)info), null, false);
            PKIXX509CredentialTrustEngine trustEngine = new PKIXX509CredentialTrustEngine((PKIXValidationInformationResolver)resolver, null);
            HttpClientSecurityParameters params = new HttpClientSecurityParameters();
            params.setTLSTrustEngine((TrustEngine)trustEngine);
            HttpClientSecurityContextHandler handler = new HttpClientSecurityContextHandler();
            handler.setHttpClientSecurityParameters(params);
            handler.initialize();
            theResource.setHttpClientContextHandler((HttpClientContextHandler)handler);
        } else {
            this.log.debug("Auto-wiring ExplicitKeyTrustEngine into HTTPResource");
            ExplicitKeyTrustEngine trustEngine = new ExplicitKeyTrustEngine((CredentialResolver)new StaticCredentialResolver(this.getCredentials()));
            HttpClientSecurityParameters params = new HttpClientSecurityParameters();
            params.setTLSTrustEngine((TrustEngine)trustEngine);
            HttpClientSecurityContextHandler handler = new HttpClientSecurityContextHandler();
            handler.setHttpClientSecurityParameters(params);
            handler.initialize();
            theResource.setHttpClientContextHandler((HttpClientContextHandler)handler);
        }
        return theResource;
    }
}

