/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.metadata;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.spring.metadata.AbstractMetadataProviderParser;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.spring.tls.TLSSocketFactoryFactoryBean;
import org.slf4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class HTTPMetadataProvidersParserSupport {
    @Nonnull
    @NotEmpty
    public static final String METADATA_URL = "metadataURL";
    @Nonnull
    public static final QName TLS_TRUST_ENGINE_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "TLSTrustEngine");
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(HTTPMetadataProvidersParserSupport.class);

    private HTTPMetadataProvidersParserSupport() {
    }

    @Nonnull
    protected static BeanDefinition buildTLSSocketFactory(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nullable String httpClientSecurityParametersRef, @Nullable BeanDefinition httpClientSecurityParameters) {
        Constraint.isNotNull((Object)LOG, (String)"LOG must be present");
        BeanDefinitionBuilder tlsSocketFactoryBuilder = BeanDefinitionBuilder.genericBeanDefinition(TLSSocketFactoryFactoryBean.class);
        if (element.hasAttributeNS(null, "disregardTLSCertificate")) {
            tlsSocketFactoryBuilder.addPropertyValue("connectionDisregardTLSCertificate", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "disregardTLSCertificate")));
        }
        if (httpClientSecurityParametersRef != null) {
            tlsSocketFactoryBuilder.addPropertyReference("httpClientSecurityParameters", httpClientSecurityParametersRef);
        }
        if (httpClientSecurityParameters != null) {
            tlsSocketFactoryBuilder.addPropertyValue("httpClientSecurityParameters", (Object)httpClientSecurityParameters);
        }
        return tlsSocketFactoryBuilder.getBeanDefinition();
    }

    @Nullable
    protected static BeanDefinition parseTLSTrustEngine(@Nullable Element tlsTrustEngine, @Nonnull ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(HttpClientSecurityParameters.class);
        if (tlsTrustEngine != null) {
            Element trustEngine = ElementSupport.getFirstChildElement((Node)tlsTrustEngine, (QName)AbstractMetadataProviderParser.TRUST_ENGINE_ELEMENT_NAME);
            if (trustEngine == null) {
                LOG.warn("{}:, Element {} did not contain a {} child element", new Object[]{parserContext.getReaderContext().getResource().getDescription(), TLS_TRUST_ENGINE_ELEMENT_NAME, AbstractMetadataProviderParser.TRUST_ENGINE_ELEMENT_NAME});
                return null;
            }
            builder.addPropertyValue("tLSTrustEngine", (Object)SpringSupport.parseCustomElement((Element)trustEngine, (ParserContext)parserContext, (BeanDefinitionBuilder)builder, (boolean)false));
        }
        return builder.getBeanDefinition();
    }

    @Nonnull
    protected static BeanDefinitionBuilder buildCommonClientBuilder(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull Class<?> clientBuildClass, @Nullable String httpClientSecurityParametersRef, @Nullable BeanDefinition httpClientSecurityParameters) {
        BeanDefinitionBuilder clientBuilder = BeanDefinitionBuilder.genericBeanDefinition(clientBuildClass);
        clientBuilder.setLazyInit(true);
        if (element.hasAttributeNS(null, "connectionTimeout")) {
            clientBuilder.addPropertyValue("connectionTimeout", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "connectionTimeout")));
        }
        if (element.hasAttributeNS(null, "connectionRequestTimeout")) {
            clientBuilder.addPropertyValue("connectionRequestTimeout", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "connectionRequestTimeout")));
        }
        if (element.hasAttributeNS(null, "socketTimeout")) {
            clientBuilder.addPropertyValue("socketTimeout", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "socketTimeout")));
        }
        clientBuilder.addPropertyValue("tLSSocketFactory", (Object)HTTPMetadataProvidersParserSupport.buildTLSSocketFactory(element, parserContext, httpClientSecurityParametersRef, httpClientSecurityParameters));
        if (element.hasAttributeNS(null, "proxyHost")) {
            clientBuilder.addPropertyValue("connectionProxyHost", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "proxyHost")));
        }
        if (element.hasAttributeNS(null, "proxyPort")) {
            clientBuilder.addPropertyValue("connectionProxyPort", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "proxyPort")));
        }
        if (element.hasAttributeNS(null, "proxyUser")) {
            clientBuilder.addPropertyValue("connectionProxyUsername", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "proxyUser")));
        }
        if (element.hasAttributeNS(null, "proxyPassword")) {
            clientBuilder.addPropertyValue("connectionProxyPassword", (Object)element.getAttributeNS(null, "proxyPassword"));
        }
        return clientBuilder;
    }
}

