/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.metadata.filter;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.spring.metadata.filter.AbstractMetadataFilterParser;
import org.opensaml.saml.metadata.resolver.filter.impl.EntityRoleFilter;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EntityRoleFilterParser
extends AbstractMetadataFilterParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "EntityRole");

    @Nonnull
    protected Class<?> getBeanClass(@Nonnull Element element) {
        return EntityRoleFilter.class;
    }

    @Override
    protected void doParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        ArrayList<QName> retainedRoles = new ArrayList<QName>();
        List retainedRoleElems = ElementSupport.getChildElementsByTagNameNS((Node)element, (String)"urn:mace:shibboleth:2.0:metadata", (String)"RetainedRole");
        if (retainedRoleElems != null) {
            for (Element retainedRoleElem : retainedRoleElems) {
                assert (retainedRoleElem != null);
                retainedRoles.add(ElementSupport.getElementContentAsQName((Element)retainedRoleElem));
            }
        }
        builder.addConstructorArgValue(retainedRoles);
        if (element.hasAttributeNS(null, "removeRolelessEntityDescriptors")) {
            builder.addPropertyValue("removeRolelessEntityDescriptors", (Object)SpringSupport.getStringValueAsBoolean((String)element.getAttributeNS(null, "removeRolelessEntityDescriptors")));
        }
        if (element.hasAttributeNS(null, "removeEmptyEntitiesDescriptors")) {
            builder.addPropertyValue("removeEmptyEntitiesDescriptors", (Object)SpringSupport.getStringValueAsBoolean((String)element.getAttributeNS(null, "removeEmptyEntitiesDescriptors")));
        }
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

