/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.metadata.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.spring.metadata.AbstractMetadataProviderParser;
import net.shibboleth.spring.metadata.filter.AbstractMetadataFilterParser;
import org.opensaml.saml.metadata.resolver.filter.impl.SignatureValidationFilter;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.spring.credential.BasicInlineCredentialFactoryBean;
import org.opensaml.spring.credential.BasicX509CredentialFactoryBean;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.DSAKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.ECKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignatureValidationParser
extends AbstractMetadataFilterParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:metadata", "SignatureValidation");
    @Nonnull
    public static final QName PUBLIC_KEY = new QName("urn:mace:shibboleth:2.0:metadata", "PublicKey");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SignatureValidationParser.class);

    @Nonnull
    protected Class<?> getBeanClass(@Nonnull Element element) {
        return SignatureValidationFilter.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        boolean hasEngineRef = element.hasAttributeNS(null, "trustEngineRef");
        boolean hasCertFile = element.hasAttributeNS(null, "certificateFile");
        List publicKeys = ElementSupport.getChildElements((Node)element, (QName)PUBLIC_KEY);
        List trustEngines = ElementSupport.getChildElements((Node)element, (QName)AbstractMetadataProviderParser.TRUST_ENGINE_ELEMENT_NAME);
        if (hasEngineRef) {
            if (hasCertFile) {
                this.log.error("{}: trustEngineRef and certificateFile are mutually exclusive", (Object)parserContext.getReaderContext().getResource().getDescription());
                throw new BeanCreationException("trustEngineRef and certificateFile are mutually exclusive");
            }
            if (trustEngines != null && !trustEngines.isEmpty()) {
                this.log.error("{}: trustEngineRef and Embedded <TrustEngine> are mutually exclusive", (Object)parserContext.getReaderContext().getResource().getDescription());
                throw new BeanCreationException("trustEngineRef and Embedded <TrustEngine> are mutually exclusive");
            }
            if (null != publicKeys && !publicKeys.isEmpty()) {
                this.log.error("{}: trustEngineRef and certificateFile are mutually exclusive", (Object)parserContext.getReaderContext().getResource().getDescription());
                throw new BeanCreationException("trustEngineRef and embedded public keys are mutually exclusive");
            }
            builder.addConstructorArgReference(AttributeSupport.ensureAttributeValue((Element)element, null, (String)"trustEngineRef"));
        } else if (hasCertFile) {
            if (null != publicKeys && !publicKeys.isEmpty()) {
                this.log.error("{}: certificateFile and embedded public keys are mutually exclusive", (Object)parserContext.getReaderContext().getResource().getDescription());
                throw new BeanCreationException("certificateFile and embedded public keys are mutually exclusive");
            }
            if (trustEngines != null && !trustEngines.isEmpty()) {
                this.log.error("{}: certificateFile and Embedded <TrustEngine> are mutually exclusive", (Object)parserContext.getReaderContext().getResource().getDescription());
                throw new BeanCreationException("Embedded <TrustEngine> and certificateFile are mutually exclusive");
            }
            this.buildTrustEngine(builder, this.buildCertificateCredential(element.getAttributeNS(null, "certificateFile")));
        } else if (null != trustEngines && !trustEngines.isEmpty()) {
            if (trustEngines.size() > 1) {
                this.log.error("{}: Too many <TrustEngine> elements", (Object)parserContext.getReaderContext().getResource().getDescription());
                throw new BeanCreationException("Too many <TrustEngine> elements");
            }
            ManagedList engines = SpringSupport.parseCustomElements((Collection)trustEngines, (ParserContext)parserContext, (BeanDefinitionBuilder)builder);
            if (engines == null || engines.isEmpty()) throw new BeanCreationException("Unable to parse <TrustEngine> element");
            builder.addConstructorArgValue(engines.get(0));
        } else {
            this.buildTrustEngine(builder, this.buildPublicKeyCredential(parserContext, publicKeys));
        }
        if (element.hasAttributeNS(null, "requireSignedRoot")) {
            builder.addPropertyValue("requireSignedRoot", (Object)SpringSupport.getStringValueAsBoolean((String)element.getAttributeNS(null, "requireSignedRoot")));
        }
        if (element.hasAttributeNS(null, "alwaysVerifyTrustedSource")) {
            builder.addPropertyValue("alwaysVerifyTrustedSource", (Object)SpringSupport.getStringValueAsBoolean((String)element.getAttributeNS(null, "alwaysVerifyTrustedSource")));
        }
        if (element.hasAttributeNS(null, "defaultCriteriaRef")) {
            builder.addPropertyReference("defaultCriteria", AttributeSupport.ensureAttributeValue((Element)element, null, (String)"defaultCriteriaRef"));
        } else {
            builder.addPropertyReference("defaultCriteria", "shibboleth.MetadataSignatureValidationStaticCriteria");
        }
        if (element.hasAttributeNS(null, "signaturePrevalidatorRef")) {
            builder.addPropertyReference("signaturePrevalidator", AttributeSupport.ensureAttributeValue((Element)element, null, (String)"signaturePrevalidatorRef"));
        }
        if (!element.hasAttributeNS(null, "dynamicTrustedNamesStrategyRef")) return;
        builder.addPropertyReference("dynamicTrustedNamesStrategy", AttributeSupport.ensureAttributeValue((Element)element, null, (String)"dynamicTrustedNamesStrategyRef"));
    }

    private void buildTrustEngine(@Nonnull BeanDefinitionBuilder builder, @Nonnull BeanDefinition credential) {
        BeanDefinitionBuilder trustEngineBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExplicitKeySignatureTrustEngine.class);
        BeanDefinitionBuilder resolver = BeanDefinitionBuilder.genericBeanDefinition(StaticCredentialResolver.class);
        resolver.addConstructorArgValue((Object)credential);
        trustEngineBuilder.addConstructorArgValue((Object)resolver.getBeanDefinition());
        ArrayList<Object> keyInfoProviders = new ArrayList<Object>();
        keyInfoProviders.add(new DSAKeyValueProvider());
        keyInfoProviders.add(new RSAKeyValueProvider());
        keyInfoProviders.add(new ECKeyValueProvider());
        keyInfoProviders.add(new InlineX509DataProvider());
        trustEngineBuilder.addConstructorArgValue((Object)new BasicProviderKeyInfoCredentialResolver(keyInfoProviders));
        builder.addConstructorArgValue((Object)trustEngineBuilder.getBeanDefinition());
    }

    @Nonnull
    private BeanDefinition buildPublicKeyCredential(@Nonnull ParserContext parserContext, @Nullable List<Element> publicKeys) {
        if (null == publicKeys || publicKeys.isEmpty()) {
            this.log.error("{}: SignatureValidation filter must have a 'trustEngineRef' attribute, a 'certificateFile' attribute or <PublicKey> elements", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanCreationException("SignatureValidation filter must have a 'trustEngineRef' attribute, a 'certificateFile' attribute or <PublicKey> elements");
        }
        if (publicKeys.size() > 1) {
            this.log.error("{}: Only one <PublicKey> element may be specified", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanCreationException("Only one <PublicKey> element may be specified");
        }
        BeanDefinitionBuilder credentialBuilder = BeanDefinitionBuilder.genericBeanDefinition(BasicInlineCredentialFactoryBean.class);
        String keyAsString = StringSupport.trimOrNull((String)publicKeys.get(0).getTextContent());
        if (null == keyAsString) {
            this.log.error("{}: <PublicKey> must contain the public key", (Object)parserContext.getReaderContext().getResource().getDescription());
            throw new BeanCreationException("<PublicKey> must contain the public key");
        }
        ManagedList keys = new ManagedList(1);
        keys.add(keyAsString);
        credentialBuilder.addPropertyValue("publicKeyInfo", (Object)keyAsString);
        return credentialBuilder.getBeanDefinition();
    }

    @Nonnull
    private BeanDefinition buildCertificateCredential(@Nonnull @NotEmpty String attribute) {
        BeanDefinitionBuilder credentialBuilder = BeanDefinitionBuilder.genericBeanDefinition(BasicX509CredentialFactoryBean.class);
        ManagedList certs = new ManagedList(1);
        certs.add(attribute);
        credentialBuilder.addPropertyValue("certificates", (Object)certs);
        return credentialBuilder.getBeanDefinition();
    }

    protected boolean shouldGenerateId() {
        return true;
    }
}

