/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.security.trust;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.spring.security.trust.AbstractTrustEngineParser;
import net.shibboleth.spring.security.trust.PKIXValidationOptionsParser;
import org.opensaml.security.x509.impl.BasicX509CredentialNameEvaluator;
import org.opensaml.security.x509.impl.CertPathPKIXTrustEvaluator;
import org.opensaml.security.x509.impl.DummyX509CredentialNameEvaluator;
import org.opensaml.security.x509.impl.StaticPKIXValidationInformationResolver;
import org.opensaml.security.x509.impl.X509CredentialNameEvaluator;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractStaticPKIXParser
extends AbstractTrustEngineParser {
    @Nonnull
    public static final QName VALIDATION_INFO = new QName("urn:mace:shibboleth:2.0:security", "ValidationInfo");
    @Nonnull
    public static final QName TRUSTED_NAMES = new QName("urn:mace:shibboleth:2.0:security", "TrustedName");

    @Nonnull
    protected BeanDefinition getPKIXValidationInformationResolver(@Nonnull Element element, @Nonnull ParserContext parserContext) {
        List validationInfoElements = ElementSupport.getChildElements((Node)element, (QName)VALIDATION_INFO);
        List trustedNameElements = ElementSupport.getChildElements((Node)element, (QName)TRUSTED_NAMES);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(StaticPKIXValidationInformationResolver.class);
        builder.addConstructorArgValue((Object)SpringSupport.parseCustomElements((Collection)validationInfoElements, (ParserContext)parserContext, (BeanDefinitionBuilder)builder));
        builder.addConstructorArgValue((Object)SpringSupport.getElementTextContentAsManagedList((Collection)trustedNameElements));
        return builder.getBeanDefinition();
    }

    @Nonnull
    protected BeanDefinition getPKIXTrustEvaluator(@Nonnull Element element, @Nonnull ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CertPathPKIXTrustEvaluator.class);
        List validationOptionsElements = ElementSupport.getChildElements((Node)element, (QName)PKIXValidationOptionsParser.ELEMENT_NAME);
        if (null != validationOptionsElements && !validationOptionsElements.isEmpty()) {
            builder.addConstructorArgValue((Object)SpringSupport.parseCustomElements((Collection)validationOptionsElements, (ParserContext)parserContext, (BeanDefinitionBuilder)builder));
        }
        return builder.getBeanDefinition();
    }

    @Nonnull
    protected Object getX509CredentialNameEvaluator(@Nonnull Element element, @Nonnull ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(X509CredentialNameEvaluatorFactoryBean.class);
        if (element.hasAttributeNS(null, "trustedNameCheckEnabled")) {
            builder.addPropertyValue("trustedNameCheckEnabled", (Object)SpringSupport.getStringValueAsBoolean((String)element.getAttributeNS(null, "trustedNameCheckEnabled")));
        }
        return builder.getBeanDefinition();
    }

    protected static class X509CredentialNameEvaluatorFactoryBean
    extends AbstractFactoryBean<X509CredentialNameEvaluator> {
        private boolean trustedNameCheckEnabled = true;

        protected X509CredentialNameEvaluatorFactoryBean() {
        }

        public void setTrustedNameCheckEnabled(boolean enabled) {
            this.trustedNameCheckEnabled = enabled;
        }

        @Nonnull
        public Class<?> getObjectType() {
            return X509CredentialNameEvaluator.class;
        }

        @Nonnull
        protected X509CredentialNameEvaluator createInstance() throws Exception {
            if (this.trustedNameCheckEnabled) {
                return new BasicX509CredentialNameEvaluator();
            }
            return new DummyX509CredentialNameEvaluator();
        }
    }
}

