/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.security.trust;

import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.spring.security.trust.PKIXValidationOptionsParser;
import org.opensaml.security.x509.impl.CertPathPKIXValidationOptions;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CertPathPKIXValidationOptionsParser
extends PKIXValidationOptionsParser {
    @Nonnull
    public static final QName SCHEMA_TYPE = new QName("urn:mace:shibboleth:2.0:security", "CertPathValidationOptionsType");
    @Nonnull
    public static final QName POLICY_OID_ELEMENT = new QName("urn:mace:shibboleth:2.0:security", "PolicyOID");

    @Override
    @Nonnull
    protected Class<?> getBeanClass(@Nonnull Element element) {
        return CertPathPKIXValidationOptions.class;
    }

    @Override
    protected void doParse(@Nonnull Element element, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        List childElems;
        super.doParse(element, parserContext, builder);
        if (element.hasAttributeNS(null, "forceRevocationEnabled")) {
            builder.addPropertyValue("forceRevocationEnabled", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "forceRevocationEnabled")));
        }
        if (element.hasAttributeNS(null, "revocationEnabled")) {
            builder.addPropertyValue("revocationEnabled", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "revocationEnabled")));
        }
        if (element.hasAttributeNS(null, "policyMappingInhibit")) {
            builder.addPropertyValue("policyMappingInhibit", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "policyMappingInhibit")));
        }
        if (element.hasAttributeNS(null, "anyPolicyInhibit")) {
            builder.addPropertyValue("anyPolicyInhibit", (Object)StringSupport.trimOrNull((String)element.getAttributeNS(null, "anyPolicyInhibit")));
        }
        if (null != (childElems = ElementSupport.getChildElements((Node)element, (QName)POLICY_OID_ELEMENT)) && !childElems.isEmpty()) {
            ManagedList initialPolicies = new ManagedList(childElems.size());
            for (Element nameElem : childElems) {
                String value = StringSupport.trimOrNull((String)nameElem.getTextContent());
                if (null == value) continue;
                initialPolicies.add(value);
            }
            builder.addPropertyValue("initialPolicies", (Object)initialPolicies);
        }
    }
}

