/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.context.logic;

import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.DateTimeAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.profile.context.logic.AbstractAttributePredicate;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DateAttributePredicate
extends AbstractAttributePredicate {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DateAttributePredicate.class);
    @Nonnull
    @NotEmpty
    private final String attributeName;
    @Nullable
    private final DateTimeFormatter dateTimeFormatter;
    @Nonnull
    private Duration systemTimeOffset;
    private boolean resultIfMissing;

    public DateAttributePredicate(@Nonnull @ParameterName(name="attribute") @NotEmpty String attribute) {
        this.attributeName = (String)Constraint.isNotNull((Object)attribute, (String)"Attribute cannot be null");
        this.dateTimeFormatter = null;
        this.systemTimeOffset = Duration.ZERO;
    }

    public DateAttributePredicate(@Nonnull @ParameterName(name="attribute") @NotEmpty String attribute, @Nonnull @ParameterName(name="formatter") DateTimeFormatter formatter) {
        this.attributeName = (String)Constraint.isNotNull((Object)attribute, (String)"Attribute cannot be null");
        this.dateTimeFormatter = (DateTimeFormatter)Constraint.isNotNull((Object)formatter, (String)"Formatter cannot be null");
        this.systemTimeOffset = Duration.ZERO;
    }

    public DateAttributePredicate(@Nonnull @ParameterName(name="attribute") @NotEmpty String attribute, @Nonnull @ParameterName(name="formatString") @NotEmpty String formatString) {
        this.attributeName = (String)Constraint.isNotNull((Object)attribute, (String)"Attribute cannot be null");
        this.dateTimeFormatter = DateTimeFormatter.ofPattern((String)Constraint.isNotNull((Object)formatString, (String)"Format string cannot be null"));
        this.systemTimeOffset = Duration.ZERO;
    }

    public void setOffset(@Nonnull Duration offset) {
        this.systemTimeOffset = (Duration)Constraint.isNotNull((Object)offset, (String)"Offset cannot be null");
    }

    public void setResultIfMissing(boolean flag) {
        this.resultIfMissing = flag;
    }

    @Override
    protected boolean allowNullAttributeContext() {
        return this.resultIfMissing;
    }

    @Override
    protected boolean hasMatch(@Nonnull Map<String, IdPAttribute> attributeMap) {
        IdPAttribute attribute = attributeMap.get(this.attributeName);
        if (attribute == null) {
            this.log.debug("Attribute {} not found in context, returning {}", (Object)this.attributeName, (Object)this.resultIfMissing);
            return this.resultIfMissing;
        }
        if (attribute.getValues().isEmpty()) {
            this.log.debug("Attribute {} has no values, returning {}", (Object)this.attributeName, (Object)this.resultIfMissing);
            return this.resultIfMissing;
        }
        Instant now = Instant.now();
        for (IdPAttributeValue value : attribute.getValues()) {
            if (value instanceof DateTimeAttributeValue && ((DateTimeAttributeValue)value).getValue().plus(this.systemTimeOffset).isAfter(now)) {
                return true;
            }
            if (value instanceof StringAttributeValue) {
                if (this.dateTimeFormatter == null) {
                    this.log.warn("No DateTimeFormatter configured, ignoring string value");
                    continue;
                }
                String dateString = ((StringAttributeValue)value).getValue();
                try {
                    assert (this.dateTimeFormatter != null);
                    if (!Instant.from(this.dateTimeFormatter.parse(dateString)).plus(this.systemTimeOffset).isAfter(now)) continue;
                    return true;
                }
                catch (DateTimeException e) {
                    this.log.warn("{} is not a valid date for the configured formatting string", (Object)dateString, (Object)e);
                    continue;
                }
            }
            this.log.warn("Ignoring unsupported value type: {}", (Object)value.getClass().getName());
        }
        return false;
    }
}

