/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.context.navigate.messaging;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractRelyingPartyLookupFunction<ResultType>
implements ContextDataLookupFunction<MessageContext, ResultType> {
    @Nonnull
    private Function<MessageContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    @Nonnull
    private Function<MessageContext, ProfileRequestContext> profileRequestContextLookupStrategy = new RecursiveTypedParentContextLookup(ProfileRequestContext.class);

    public AbstractRelyingPartyLookupFunction() {
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class).compose((Function)new RecursiveTypedParentContextLookup(InOutOperationContext.class));
    }

    @Nonnull
    public Function<MessageContext, RelyingPartyContext> getRelyingPartyContextLookupStrategy() {
        return this.relyingPartyContextLookupStrategy;
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<MessageContext, RelyingPartyContext> strategy) {
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    @Nonnull
    public Function<MessageContext, ProfileRequestContext> getProfileRequestContextLookupStrategy() {
        return this.profileRequestContextLookupStrategy;
    }

    public void setProfileRequestContextLookupStrategy(@Nonnull Function<MessageContext, ProfileRequestContext> strategy) {
        this.profileRequestContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileRequestContext lookup strategy cannot be null");
    }

    @Nullable
    protected RelyingPartyContext getRelyingPartyContext(@Nullable MessageContext input) {
        return this.relyingPartyContextLookupStrategy.apply(input);
    }

    @Nullable
    protected ProfileRequestContext getProfileRequestContext(@Nullable MessageContext input) {
        return this.profileRequestContextLookupStrategy.apply(input);
    }
}

