/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.installablecomponent;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.installablecomponent.InstallableComponentSupport;
import net.shibboleth.profile.installablecomponent.InstallableComponentVersion;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public abstract class InstallableComponentInfo {
    @Nonnull
    private static final Pattern SPACE_CONTAINING = Pattern.compile("\\s+");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InstallableComponentInfo.class);
    @Nonnull
    private final Map<InstallableComponentVersion, VersionInfo> versionInfo = new HashMap<InstallableComponentVersion, VersionInfo>();
    @Nonnull
    private final Map<InstallableComponentVersion, Pair<URL, String>> downloadInfo = new HashMap<InstallableComponentVersion, Pair<URL, String>>();
    @Nonnull
    private final String componentId;
    private boolean allInfoPresent = true;

    public InstallableComponentInfo(@Nonnull String id, @Nonnull Properties props) {
        this.componentId = id;
        this.parse(props);
    }

    public boolean isInfoComplete() {
        return this.allInfoPresent;
    }

    @Nullable
    public URL getUpdateURL(@Nonnull InstallableComponentVersion version) {
        Pair<URL, String> p = this.downloadInfo.get(version);
        if (p == null) {
            return null;
        }
        return (URL)p.getFirst();
    }

    @Nullable
    public String getUpdateBaseName(@Nonnull InstallableComponentVersion version) {
        Pair<URL, String> p = this.downloadInfo.get(version);
        if (p == null) {
            return null;
        }
        return (String)p.getSecond();
    }

    @Nonnull
    public Map<InstallableComponentVersion, VersionInfo> getAvailableVersions() {
        return this.versionInfo;
    }

    @Nonnull
    protected String getComponentId() {
        return this.componentId;
    }

    private void parse(@Nonnull Properties props) {
        String name = this.componentId + ".versions";
        String availableVersions = StringSupport.trim((String)props.getProperty(name));
        if (availableVersions == null) {
            this.log.warn("Component {}: Could not find {} property.", (Object)this.componentId, (Object)name);
            this.allInfoPresent = false;
        } else {
            this.handleAvailableVersions(props, availableVersions);
        }
    }

    private void handleAvailableVersion(@Nonnull Properties props, @Nonnull String version) {
        InstallableComponentSupport.SupportLevel supportLevel;
        InstallableComponentVersion maxVersionInfo;
        InstallableComponentVersion theVersion = new InstallableComponentVersion(version);
        if (theVersion.getMajor() == 0 && theVersion.getMinor() == 0 && theVersion.getPatch() == 0) {
            this.log.warn("Component {}: Improbable version {}", (Object)this.componentId, (Object)version);
        }
        if (this.versionInfo.containsKey(theVersion)) {
            this.log.warn("Component {}: Duplicate version {}", (Object)this.componentId, (Object)version);
        }
        if ((maxVersionInfo = this.getMaxVersion(props, version)) == null) {
            this.log.warn("Component {}, Version {}: Could not find max idp version.", (Object)this.componentId, (Object)version);
            this.allInfoPresent = false;
            return;
        }
        InstallableComponentVersion minVersionInfo = this.getMinVersion(props, version);
        if (minVersionInfo == null) {
            this.log.warn("Component {}, Version {}: Could not find min idp version.", (Object)this.componentId, (Object)version);
            this.allInfoPresent = false;
            return;
        }
        String supportLevelString = StringSupport.trimOrNull((String)props.getProperty(this.componentId + ".supportLevel." + version));
        if (supportLevelString == null) {
            this.log.debug("Component {}, Version {}: Could not find support level for {}.", (Object)this.componentId, (Object)version);
            supportLevel = InstallableComponentSupport.SupportLevel.Unknown;
        } else {
            try {
                supportLevel = Enum.valueOf(InstallableComponentSupport.SupportLevel.class, supportLevelString);
            }
            catch (IllegalArgumentException e) {
                this.log.warn("Component {}, Version {}: Invalid support level {}.", new Object[]{this.componentId, version, supportLevelString});
                supportLevel = InstallableComponentSupport.SupportLevel.Unknown;
            }
        }
        this.log.debug("Component {}: MaxIdP {}, MinIdP {}, Support Level {}", new Object[]{this.componentId, maxVersionInfo, minVersionInfo, supportLevel});
        VersionInfo info = new VersionInfo(maxVersionInfo, minVersionInfo, supportLevel);
        this.versionInfo.put(theVersion, info);
        Object downloadURL = StringSupport.trimOrNull((String)this.getDefaultedValue(props, ".downloadURL.", version));
        String baseName = StringSupport.trimOrNull((String)this.getDefaultedValue(props, ".baseName.", version));
        if (baseName != null && downloadURL != null) {
            try {
                if (!((String)downloadURL).endsWith("/")) {
                    downloadURL = (String)downloadURL + "/";
                }
                URL url = new URL((String)downloadURL);
                this.downloadInfo.put(theVersion, (Pair<URL, String>)new Pair((Object)url, (Object)baseName));
                this.log.trace("Component {}, version {}: Added download URL {}  baseName {} for {}", new Object[]{this.componentId, theVersion, url, baseName});
            }
            catch (MalformedURLException e) {
                this.log.warn("Component {}, version {}: Download URL '{}' could not be constructed", new Object[]{this.componentId, theVersion, downloadURL, e});
            }
        } else {
            this.log.info("Component {}, version {}: no download information present", (Object)this.componentId, (Object)theVersion);
        }
    }

    @Nullable
    protected abstract InstallableComponentVersion getMaxVersion(@Nonnull Properties var1, @Nonnull String var2);

    @Nullable
    protected abstract InstallableComponentVersion getMinVersion(@Nonnull Properties var1, @Nonnull String var2);

    private void handleAvailableVersions(@Nonnull Properties props, @Nonnull String availableVersions) {
        String[] versions = SPACE_CONTAINING.split(availableVersions, 0);
        this.log.debug("Component {}: Available versions : {} ", (Object)this.componentId, (Object)availableVersions);
        for (String version : versions) {
            assert (version != null);
            this.log.debug("Component {}: Considering {}", (Object)this.componentId, (Object)version);
            this.handleAvailableVersion(props, version);
        }
    }

    @Nullable
    private String getDefaultedValue(@Nonnull Properties props, @Nonnull String interfix, @Nonnull String version) {
        String result = props.getProperty(this.componentId + interfix + version);
        if (result != null) {
            return result;
        }
        result = props.getProperty(this.componentId + interfix + "%{version}");
        if (result == null) {
            return result;
        }
        return result.replaceAll("\\%\\{version\\}", version);
    }

    public boolean isSupportedWithIdPVersion(@Nonnull InstallableComponentVersion componentVersion, @Nonnull InstallableComponentVersion intsallIntoVersion) {
        VersionInfo info = this.versionInfo.get(componentVersion);
        if (info == null) {
            this.log.error("Component {}: Unknown version {} supplied.", (Object)this.componentId, (Object)componentVersion);
            this.log.debug("Component {}: Available {}", (Object)this.componentId, this.versionInfo.keySet());
            return false;
        }
        return InstallableComponentInfo.isSupportedWithIdPVersion(info, intsallIntoVersion);
    }

    public static boolean isSupportedWithIdPVersion(@Nonnull VersionInfo componentVersionInfo, @Nonnull InstallableComponentVersion installIntoVersion) {
        int maxCompare = installIntoVersion.compareTo(componentVersionInfo.getMaxSupported());
        if (maxCompare >= 0) {
            return false;
        }
        int minCompare = installIntoVersion.compareTo(componentVersionInfo.getMinSupported());
        return minCompare >= 0;
    }

    public static class VersionInfo {
        @Nonnull
        private final InstallableComponentVersion maxSupported;
        @Nonnull
        private final InstallableComponentVersion minSupported;
        @Nonnull
        private final InstallableComponentSupport.SupportLevel supportLevel;

        public VersionInfo(@Nonnull InstallableComponentVersion max, @Nonnull InstallableComponentVersion min, @Nonnull InstallableComponentSupport.SupportLevel support) {
            this.maxSupported = max;
            this.minSupported = min;
            this.supportLevel = support;
        }

        @Nonnull
        public InstallableComponentVersion getMaxSupported() {
            return this.maxSupported;
        }

        @Nonnull
        public InstallableComponentVersion getMinSupported() {
            return this.minSupported;
        }

        @Nonnull
        public InstallableComponentSupport.SupportLevel getSupportLevel() {
            return this.supportLevel;
        }
    }
}

