/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.installablecomponent;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.installablecomponent.InstallableComponentInfo;
import net.shibboleth.profile.installablecomponent.InstallableComponentVersion;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.httpclient.HttpClientContextHandler;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.spring.httpclient.resource.HTTPResource;
import org.apache.hc.client5.http.classic.HttpClient;
import org.opensaml.security.httpclient.HttpClientSecurityContextHandler;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.slf4j.Logger;
import org.springframework.core.io.FileSystemResource;

public final class InstallableComponentSupport {
    @Nonnull
    public static final String AVAILABLE_VERSIONS_PROPERTY_SUFFIX = ".versions";
    @Nonnull
    public static final String DOWNLOAD_URL_INTERFIX = ".downloadURL.";
    @Nonnull
    public static final String BASE_NAME_INTERFIX = ".baseName.";
    @Nonnull
    public static final String MAX_IDP_VERSION_INTERFIX = ".idpVersionMax.";
    @Nonnull
    public static final String MIN_IDP_VERSION_INTERFIX = ".idpVersionMin.";
    @Nonnull
    public static final String SUPPORT_LEVEL_INTERFIX = ".supportLevel.";
    @Nonnull
    public static final String VERSION_PATTERN = "%{version}";
    @Nonnull
    public static final String VERSION_PATTERN_REGEX = "\\%\\{version\\}";
    @Nonnull
    private static Logger log = LoggerFactory.getLogger(InstallableComponentSupport.class);

    private InstallableComponentSupport() {
    }

    @Nullable
    public static InstallableComponentVersion getBestVersion(@Nonnull InstallableComponentVersion installIntoVersion, @Nonnull InstallableComponentVersion pluginVersion, @Nonnull InstallableComponentInfo pluginInfo) {
        ArrayList<InstallableComponentVersion> availableVersions = new ArrayList<InstallableComponentVersion>(pluginInfo.getAvailableVersions().keySet());
        availableVersions.sort(null);
        log.debug("Considering versions: {}", availableVersions);
        for (int i = availableVersions.size() - 1; i >= 0; --i) {
            InstallableComponentVersion version = (InstallableComponentVersion)availableVersions.get(i);
            if (version.compareTo(pluginVersion) <= 0) {
                log.debug("Version {} is less than or the same as {}. All done", (Object)version, (Object)pluginVersion);
                return null;
            }
            InstallableComponentInfo.VersionInfo versionInfo = pluginInfo.getAvailableVersions().get(version);
            if (versionInfo.getSupportLevel() != SupportLevel.Current) {
                log.debug("Version {} has support level {}, ignoring", (Object)version, (Object)versionInfo.getSupportLevel());
                continue;
            }
            if (!pluginInfo.isSupportedWithIdPVersion(version, installIntoVersion)) {
                log.debug("Version {} is not supported with Application Version {}", (Object)version, (Object)installIntoVersion);
                continue;
            }
            log.debug("Version {} is supported with Application Version {}", (Object)version, (Object)installIntoVersion);
            if (pluginInfo.getUpdateURL(version) == null || pluginInfo.getUpdateBaseName(version) == null) {
                log.debug("Version {} is does not have update information", (Object)version);
                continue;
            }
            return version;
        }
        return null;
    }

    @Nullable
    public static Properties loadInfo(@Nonnull List<URL> updateURLs, @Nonnull HttpClient client, @Nullable HttpClientSecurityParameters securityParameters) {
        Properties props = new Properties();
        for (URL url : updateURLs) {
            try {
                FileSystemResource propertyResource;
                if ("file".equals(url.getProtocol())) {
                    String path = url.getPath();
                    assert (path != null);
                    propertyResource = new FileSystemResource(path);
                } else if ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol())) {
                    HTTPResource httpResource = new HTTPResource(client, url);
                    propertyResource = httpResource;
                    HttpClientSecurityContextHandler handler = new HttpClientSecurityContextHandler();
                    handler.setHttpClientSecurityParameters(securityParameters);
                    handler.initialize();
                    httpResource.setHttpClientContextHandler((HttpClientContextHandler)handler);
                } else {
                    log.error("Only file and http[s] URLs are allowed");
                    continue;
                }
                log.debug("Plugin Listing: Looking for update at {}", (Object)propertyResource.getDescription());
                if (!propertyResource.exists()) {
                    log.info("{} could not be located", (Object)propertyResource.getDescription());
                    continue;
                }
                props.load(propertyResource.getInputStream());
                return props;
            }
            catch (IOException | ComponentInitializationException e) {
                log.error("Could not open update URL {} :", (Object)url, (Object)e);
            }
        }
        log.error("Could not locate any active update servers");
        return null;
    }

    public static enum SupportLevel {
        Current,
        OutOfDate,
        Unsupported,
        Secadv,
        Withdrawn,
        Unknown;

    }
}

