/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.config.navigate.messaging;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.config.navigate.messaging.AbstractDefaultSecurityConfigurationLookupFunction;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.Live;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.security.config.SecurityConfiguration;
import org.opensaml.security.httpclient.HttpClientSecurityConfiguration;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;

public class HttpClientSecurityConfigurationLookupFunction
extends AbstractDefaultSecurityConfigurationLookupFunction<List<HttpClientSecurityConfiguration>> {
    @Nullable
    @Live
    public List<HttpClientSecurityConfiguration> apply(@Nullable MessageContext input) {
        ArrayList<HttpClientSecurityConfiguration> configs = new ArrayList<HttpClientSecurityConfiguration>();
        RelyingPartyContext rpc = this.getRelyingPartyContext(input);
        if (rpc != null) {
            SecurityConfiguration defaultConfig;
            SecurityConfiguration sc;
            ProfileConfiguration pc = rpc.getProfileConfig();
            if (pc != null && (sc = pc.getSecurityConfiguration(this.getProfileRequestContext(input))) != null && sc.getHttpClientSecurityConfiguration() != null) {
                configs.add(sc.getHttpClientSecurityConfiguration());
            }
            if ((defaultConfig = this.getDefaultSecurityConfiguration(rpc.getConfiguration(), input)) != null && defaultConfig.getHttpClientSecurityConfiguration() != null) {
                configs.add(defaultConfig.getHttpClientSecurityConfiguration());
            }
        }
        configs.add(HttpClientSecuritySupport.getGlobalHttpClientSecurityConfiguration());
        return configs;
    }
}

