/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.module;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.module.ModuleContext;
import net.shibboleth.profile.module.ModuleException;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.component.IdentifiedComponent;

public interface Module
extends IdentifiedComponent {
    @Nonnull
    @NotEmpty
    public String getName(@Nullable ModuleContext var1);

    @Nullable
    @NotEmpty
    public String getDescription(@Nullable ModuleContext var1);

    @Nullable
    @NotEmpty
    public String getURL();

    @Nullable
    @NotEmpty
    public String getOwnerId();

    public boolean isHttpClientRequired();

    @Nonnull
    @Unmodifiable
    @NotLive
    public Collection<ModuleResource> getResources();

    public boolean isEnabled(@Nonnull ModuleContext var1);

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<ModuleResource, ResourceResult> enable(@Nonnull ModuleContext var1) throws ModuleException;

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<ModuleResource, ResourceResult> disable(@Nonnull ModuleContext var1, boolean var2) throws ModuleException;

    @Nonnull
    public String getSaveExtension();

    @Nonnull
    public String getNewExtension();

    public static enum ResourceResult {
        CREATED,
        REPLACED,
        ADDED,
        REMOVED,
        SAVED,
        MISSING;

    }

    public static interface ModuleResource {
        @Nonnull
        public String getSource();

        @Nonnull
        public Path getDestination();

        public boolean isReplace();

        public boolean isOptional();

        public boolean isExecutable();

        public boolean isWindows();

        public boolean isNonWindows();
    }
}

