/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.module;

import java.io.PrintStream;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import org.apache.hc.client5.http.classic.HttpClient;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;

public class ModuleContext {
    @Nonnull
    private String installationHome;
    @Nullable
    private HttpClient httpClient;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParams;
    @Nonnull
    private List<Locale.LanguageRange> languageRanges;
    @Nullable
    private PrintStream messageStream;

    public ModuleContext(@Nonnull @NotEmpty String home) {
        this.installationHome = Constraint.isNotEmpty((String)home, (String)"Home location cannot be null or empty");
        this.languageRanges = CollectionSupport.emptyList();
    }

    @Nonnull
    @NotEmpty
    public String getInstallLocation() {
        return this.installationHome;
    }

    @Nullable
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(@Nullable HttpClient client) {
        this.httpClient = client;
    }

    @Nullable
    public HttpClientSecurityParameters getHttpClientSecurityParameters() {
        return this.httpClientSecurityParams;
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.httpClientSecurityParams = params;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<Locale.LanguageRange> getLanguageRanges() {
        return this.languageRanges;
    }

    public void setLanguageRanges(@Nullable List<Locale.LanguageRange> ranges) {
        this.languageRanges = ranges != null ? CollectionSupport.copyToList(ranges) : CollectionSupport.emptyList();
    }

    @Nullable
    public PrintStream getMessageStream() {
        return this.messageStream;
    }

    public void setMessageStream(@Nullable PrintStream stream) {
        this.messageStream = stream;
    }
}

