/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.context;

import jakarta.servlet.ServletContext;
import javax.annotation.Nonnull;
import net.shibboleth.shared.spring.resource.ConditionalResourceResolver;
import net.shibboleth.shared.spring.util.AnnotationParameterNameDiscoverer;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class FilesystemGenericWebApplicationContext
extends GenericWebApplicationContext {
    public FilesystemGenericWebApplicationContext() {
        this.getDefaultListableBeanFactory().setParameterNameDiscoverer((ParameterNameDiscoverer)new AnnotationParameterNameDiscoverer());
        this.addProtocolResolver(new ConditionalResourceResolver());
    }

    public FilesystemGenericWebApplicationContext(@Nonnull DefaultListableBeanFactory beanFactory) {
        super(beanFactory);
        beanFactory.setParameterNameDiscoverer((ParameterNameDiscoverer)new AnnotationParameterNameDiscoverer());
        this.addProtocolResolver(new ConditionalResourceResolver());
    }

    public FilesystemGenericWebApplicationContext(@Nonnull ServletContext context) {
        super(context);
        this.getDefaultListableBeanFactory().setParameterNameDiscoverer((ParameterNameDiscoverer)new AnnotationParameterNameDiscoverer());
        this.addProtocolResolver(new ConditionalResourceResolver());
    }

    public FilesystemGenericWebApplicationContext(@Nonnull DefaultListableBeanFactory beanFactory, ServletContext context) {
        super(beanFactory, context);
        beanFactory.setParameterNameDiscoverer((ParameterNameDiscoverer)new AnnotationParameterNameDiscoverer());
        this.addProtocolResolver(new ConditionalResourceResolver());
    }

    @Nonnull
    protected Resource getResourceByPath(@Nonnull String path) {
        try {
            FileSystemResource r = new FileSystemResource(path);
            if (r.exists()) {
                return r;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getResourceByPath(path);
    }
}

