/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.expression;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public abstract class AbstractSpringExpressionEvaluator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractSpringExpressionEvaluator.class);
    @Nonnull
    private final String springExpression;
    @Nullable
    private Object customObject;
    @Nullable
    private Class<?> outputType;
    private boolean hideExceptions;
    @Nullable
    private Object returnOnError;

    public AbstractSpringExpressionEvaluator(@Nonnull @ParameterName(name="expression") @NotEmpty String expression) {
        this.springExpression = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)expression), (String)"Expression cannot be null or empty");
    }

    @Nullable
    protected Class<?> getOutputType() {
        return this.outputType;
    }

    protected void setOutputType(@Nullable Class<?> type) {
        this.outputType = type;
    }

    @Nullable
    protected Object getCustomObject() {
        return this.customObject;
    }

    public void setCustomObject(@Nullable Object object) {
        this.customObject = object;
    }

    public void setHideExceptions(boolean flag) {
        this.hideExceptions = flag;
    }

    @Nullable
    protected Object getReturnOnError() {
        return this.returnOnError;
    }

    protected void setReturnOnError(@Nullable Object value) {
        this.returnOnError = value;
    }

    @Nullable
    protected Object evaluate(Object ... input) {
        try {
            SpelExpressionParser parser = new SpelExpressionParser();
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setVariable("custom", this.customObject);
            this.prepareContext((EvaluationContext)context, input);
            Object output = parser.parseExpression(this.springExpression).getValue((EvaluationContext)context);
            if (output == null) {
                return null;
            }
            Class<?> otype = this.getOutputType();
            if (null != otype) {
                if (!otype.isInstance(output)) {
                    this.log.error("Output of type {} was not of type {}", output.getClass(), otype);
                    return this.returnOnError;
                }
                return otype.cast(output);
            }
            return output;
        }
        catch (Exception e) {
            this.log.error("Error evaluating Spring expression", (Throwable)e);
            if (this.hideExceptions) {
                return this.returnOnError;
            }
            throw e;
        }
    }

    protected abstract void prepareContext(@Nonnull EvaluationContext var1, Object ... var2);
}

