/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.config;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedSet;

public class RelocatedBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    @Nonnull
    private Map<String, String> movedClasses = CollectionSupport.emptyMap();
    @Nonnull
    private Map<String, String> movedBeans = CollectionSupport.emptyMap();

    public void setClasses(@Nonnull @ParameterName(name="classes") Map<String, String> classes) {
        this.movedClasses = new HashMap<String, String>(classes.size());
        classes.forEach((k, v) -> {
            String key = StringSupport.trimOrNull((String)k);
            String val = StringSupport.trimOrNull((String)v);
            if (key != null) {
                this.movedClasses.put(key, val);
            }
        });
    }

    public void setBeans(@Nonnull @ParameterName(name="classes") Map<String, String> beans) {
        this.movedBeans = new HashMap<String, String>(beans.size());
        beans.forEach((k, v) -> {
            String key = StringSupport.trimOrNull((String)k);
            String val = StringSupport.trimOrNull((String)v);
            if (key != null) {
                this.movedBeans.put(key, val);
            }
        });
    }

    private void processBeanDefinition(@Nonnull BeanDefinition def, @Nonnull String name) {
        String parentName;
        String className = def.getBeanClassName();
        if (className != null && this.movedClasses.containsKey(className)) {
            DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CLASS, (String)className, (String)("Bean ID: " + name), (String)this.movedClasses.get(className));
            def.setBeanClassName(this.movedClasses.get(className));
        }
        if ((parentName = def.getParentName()) != null && this.movedBeans.containsKey(parentName)) {
            DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.BEAN, (String)parentName, (String)("Bean ID: " + name), (String)this.movedBeans.get(parentName));
            def.setParentName(this.movedBeans.get(parentName));
        }
        for (PropertyValue property : def.getPropertyValues()) {
            BeanDefinitionHolder defHolder;
            Object propValue = property.getValue();
            if (propValue instanceof BeanDefinitionHolder) {
                BeanDefinitionHolder defHolder2 = (BeanDefinitionHolder)propValue;
                this.processBeanDefinition(defHolder2.getBeanDefinition(), defHolder2.getBeanName());
                continue;
            }
            if (propValue instanceof ManagedList) {
                ManagedList pv = (ManagedList)propValue;
                for (Object value : pv) {
                    if (!(value instanceof BeanDefinitionHolder)) continue;
                    defHolder = (BeanDefinitionHolder)value;
                    this.processBeanDefinition(defHolder.getBeanDefinition(), defHolder.getBeanName());
                }
                continue;
            }
            if (!(propValue instanceof ManagedSet)) continue;
            ManagedSet pv = (ManagedSet)propValue;
            for (Object value : pv) {
                if (!(value instanceof BeanDefinitionHolder)) continue;
                defHolder = (BeanDefinitionHolder)value;
                this.processBeanDefinition(defHolder.getBeanDefinition(), defHolder.getBeanName());
            }
        }
    }

    public void postProcessBeanFactory(@Nonnull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        for (String name : beanFactory.getBeanDefinitionNames()) {
            assert (name != null);
            BeanDefinition def = beanFactory.getBeanDefinition(name);
            this.processBeanDefinition(def, name);
        }
    }
}

