/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.context;

import javax.annotation.Nonnull;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.spring.resource.ConditionalResourceResolver;
import net.shibboleth.shared.spring.util.AnnotationParameterNameDiscoverer;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class FileSystemXmlWebApplicationContext
extends XmlWebApplicationContext {
    public FileSystemXmlWebApplicationContext() {
        this.addProtocolResolver(new ConditionalResourceResolver());
    }

    @Nonnull
    protected Resource getResourceByPath(@Nonnull String path) {
        try {
            FileSystemResource r = new FileSystemResource(path);
            if (r.exists()) {
                return r;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getResourceByPath(path);
    }

    @Nonnull
    public Resource getResource(@Nonnull String location) {
        Constraint.isNotNull((Object)location, (String)"Location must not be null");
        if (location.startsWith("classpath*:")) {
            return new ClassPathResource(location.substring("classpath*:".length()), this.getClassLoader());
        }
        return super.getResource(location);
    }

    @Nonnull
    protected DefaultListableBeanFactory createBeanFactory() {
        DefaultListableBeanFactory result = super.createBeanFactory();
        result.setParameterNameDiscoverer((ParameterNameDiscoverer)new AnnotationParameterNameDiscoverer());
        return result;
    }
}

