/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.resource;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractIdentifiedInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.spring.resource.ResourceHelper;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.core.io.Resource;

public class ConditionalResource
extends AbstractIdentifiedInitializableComponent
implements Resource,
BeanNameAware,
net.shibboleth.shared.resource.Resource {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_CONTENT = "<beans xmlns=\"http://www.springframework.org/schema/beans\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd\"></beans>";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ConditionalResource.class);
    @Nullable
    private String logPrefix;
    @Nonnull
    private final Resource wrappedResource;
    @NonnullAfterInit
    private String defaultContent;

    public ConditionalResource(@Nonnull Resource wrapped) {
        this.wrappedResource = (Resource)Constraint.isNotNull((Object)wrapped, (String)"Wrapped resource cannot be null");
        this.defaultContent = DEFAULT_CONTENT;
    }

    public synchronized void setId(@Nonnull @NotEmpty String id) {
        super.setId(id);
    }

    public void setDefaultContent(@Nonnull String content) {
        this.checkSetterPreconditions();
        this.defaultContent = Constraint.isNotEmpty((String)content, (String)"Empty content cannot be null");
    }

    @Nonnull
    public InputStream getInputStream() throws IOException {
        this.checkComponentActive();
        try {
            return this.wrappedResource.getInputStream();
        }
        catch (IOException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("{} getInputStream failed on wrapped resource", (Object)this.getLogPrefix(), (Object)e);
            } else {
                this.log.debug("{} getInputStream failed on wrapped resource", (Object)this.getLogPrefix());
            }
            return new ByteArrayInputStream(this.defaultContent.getBytes(StandardCharsets.UTF_8));
        }
    }

    @Nonnull
    public net.shibboleth.shared.resource.Resource createRelativeResource(@Nonnull String relativePath) throws IOException {
        this.checkComponentActive();
        Resource relative = this.wrappedResource.createRelative(relativePath);
        if (relative instanceof net.shibboleth.shared.resource.Resource) {
            return (net.shibboleth.shared.resource.Resource)relative;
        }
        return ResourceHelper.of(relative);
    }

    public void setBeanName(@Nonnull String name) {
        this.setId(name);
    }

    public boolean exists() {
        this.checkComponentActive();
        try {
            if (!this.wrappedResource.exists()) {
                this.log.debug("{} Wrapped resource does not exist", (Object)this.getLogPrefix());
            }
        }
        catch (Exception e) {
            this.log.debug("{} Wrapped resource does not exist", (Object)this.getLogPrefix(), (Object)e);
        }
        return true;
    }

    public boolean isFile() {
        this.checkComponentActive();
        return this.wrappedResource.isFile();
    }

    public boolean isReadable() {
        this.checkComponentActive();
        return true;
    }

    public boolean isOpen() {
        this.checkComponentActive();
        return this.wrappedResource.isOpen();
    }

    @Nonnull
    public URL getURL() throws IOException {
        this.checkComponentActive();
        try {
            return this.wrappedResource.getURL();
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} getURL failed on wrapped resource", (Object)this.getLogPrefix(), (Object)e);
            }
            throw e;
        }
    }

    @Nonnull
    public URI getURI() throws IOException {
        this.checkComponentActive();
        try {
            return this.wrappedResource.getURI();
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} getURI failed on wrapped resource", (Object)this.getLogPrefix(), (Object)e);
            }
            throw e;
        }
    }

    @Nonnull
    public File getFile() throws IOException {
        this.checkComponentActive();
        try {
            return this.wrappedResource.getFile();
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} getFile failed on wrapped resource", (Object)this.getLogPrefix(), (Object)e);
            }
            throw e;
        }
    }

    public long contentLength() throws IOException {
        this.checkComponentActive();
        try {
            return this.wrappedResource.contentLength();
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} contentLength failed on wrapped resource", (Object)this.getLogPrefix(), (Object)e);
            }
            return this.defaultContent.length();
        }
    }

    public long lastModified() throws IOException {
        this.checkComponentActive();
        try {
            return this.wrappedResource.lastModified();
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("{} lastModified failed on wrapped resource", (Object)this.getLogPrefix(), (Object)e);
            }
            return 0L;
        }
    }

    @Nonnull
    public Resource createRelative(@Nonnull String relativePath) throws IOException {
        this.checkComponentActive();
        return this.wrappedResource.createRelative(relativePath);
    }

    public String getFilename() {
        this.checkComponentActive();
        return this.wrappedResource.getFilename();
    }

    @Nonnull
    public String getDescription() {
        this.checkComponentActive();
        return this.wrappedResource.getDescription();
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        if (this.logPrefix != null) {
            return this.logPrefix;
        }
        this.logPrefix = "ConditionalResource " + this.getId() + ":";
        return this.logPrefix;
    }
}

